/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.application;

import jakarta.validation.Validator;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.application.Building;
import org.hibernate.beanvalidation.tck.tests.constraints.application.DummyGroup;
import org.hibernate.beanvalidation.tck.tests.constraints.application.SecurityCheck;
import org.hibernate.beanvalidation.tck.tests.constraints.application.SuperWoman;
import org.hibernate.beanvalidation.tck.tests.constraints.application.TightSecurity;
import org.hibernate.beanvalidation.tck.tests.constraints.application.Visibility;
import org.hibernate.beanvalidation.tck.tests.constraints.application.Woman;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ValidationRequirementTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ValidationRequirementTest.webArchiveBuilder().withTestClassPackage(ValidationRequirementTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-objectvalidation", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-objectvalidation", id="b")})
    public void testClassLevelConstraints() {
        Woman sarah = new Woman();
        sarah.setFirstName("Sarah");
        sarah.setLastName("Jones");
        sarah.setPersonalNumber("000000-0000");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)sarah, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(SecurityCheck.class), ConstraintViolationAssert.violationOf(SecurityCheck.class));
        violations = validator.validate((Object)sarah, new Class[]{TightSecurity.class});
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(SecurityCheck.class));
        violations = validator.validate((Object)sarah, new Class[]{DummyGroup.class});
        ConstraintViolationAssert.assertNoViolations(violations);
        sarah.setPersonalNumber("740523-1234");
        violations = validator.validate((Object)sarah, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        violations = validator.validate((Object)sarah, new Class[]{TightSecurity.class});
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="c")})
    public void testFieldAccess() {
        SuperWoman superwoman = new SuperWoman();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validateProperty((Object)superwoman, "firstName", new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        superwoman.setFirstName(null);
        violations = validator.validateProperty((Object)superwoman, "firstName", new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="d")})
    public void testPropertyAccess() {
        SuperWoman superwoman = new SuperWoman();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validateProperty((Object)superwoman, "lastName", new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
        superwoman.setHiddenName(null);
        violations = validator.validateProperty((Object)superwoman, "lastName", new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="b")})
    public void testConstraintAppliedOnFieldAndProperty() {
        Building building = new Building(10000000L);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)building, new Class[0]);
        String expectedMessage = "Building costs are max {max} dollars.";
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Max.class).withMessage(expectedMessage), ConstraintViolationAssert.violationOf(Max.class).withMessage(expectedMessage));
    }

    @Test(enabled=false)
    public void testIgnoreStaticFieldsAndProperties() {
        StaticFieldsAndProperties entity = new StaticFieldsAndProperties();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)entity, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-propertyvalidation", id="e")
    public void testFieldAndPropertyVisibilityIsNotConstrained() {
        Visibility entity = new Visibility();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)entity, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withMessage("publicField"), ConstraintViolationAssert.violationOf(Min.class).withMessage("protectedField"), ConstraintViolationAssert.violationOf(Min.class).withMessage("privateField"), ConstraintViolationAssert.violationOf(DecimalMin.class).withMessage("publicProperty"), ConstraintViolationAssert.violationOf(DecimalMin.class).withMessage("protectedProperty"), ConstraintViolationAssert.violationOf(DecimalMin.class).withMessage("privateProperty"));
        entity.setValues(100);
        violations = validator.validate((Object)entity, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(violations);
    }

    static class StaticFieldsAndProperties {
        @NotNull
        static Object staticField = null;

        StaticFieldsAndProperties() {
        }

        @NotNull
        static Object getStaticProperty() {
            return null;
        }
    }
}

