# Contributing to Eclipse Jakarta Validation

Thanks for your interest in this project.

## Project description

Validation defines a metadata model and API for JavaBean and method validation.

* https://beanvalidation.org/
* Project home: https://projects.eclipse.org/projects/ee4j.bean-validation

   See https://gitlab.eclipse.org/eclipsefdn/helpdesk/-/issues/3497 for progress of rename.

## Developer resources

Contributions from the community are essential in keeping Jakarta Validation strong and successful.

Please see the following pages to learn more about contributing to the Jakarta Validation spec, its API, TCK and website:

* [General contribution guide](https://beanvalidation.org/contribute/)
* [Contributing to the specification](https://beanvalidation.org/contribute/specification/)
* [Contributing to the API and the TCK](https://beanvalidation.org/contribute/coding)
* [Contributing to the website](https://beanvalidation.org/contribute/site)

Before working on a feature for a long time, it is recommended to discuss the suggested change,
e.g. by sending a mail to the [bean-validation-dev](https://accounts.eclipse.org/mailing-list/bean-validation-dev) mailing list.

The project maintains the following source code repositories:

* [The specification repository](https://github.com/jakartaee/validation-spec)
* [The API repository](https://github.com/jakartaee/validation)
* [The TCK repository](https://github.com/jakartaee/validation-tck)

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://accounts.eclipse.org/mailing-list/bean-validation-dev
