/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.asset.Asset;

public class FileAsset
implements Asset {
    private File file;

    public FileAsset(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must be specified");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File must exist: " + file.getAbsolutePath());
        }
        this.file = file;
    }

    public InputStream openStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file), 8192);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not open file " + this.file, e);
        }
    }

    public File getSource() {
        return this.file;
    }

    public String toString() {
        return FileAsset.class.getSimpleName() + " [file=" + this.file.getAbsolutePath() + "]";
    }
}

