/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.description;

import org.assertj.core.description.Description;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class TextDescription
extends Description {
    @VisibleForTesting
    final String value;
    final Object[] args;

    public TextDescription(String value, Object ... args) {
        this.value = value == null ? "" : value;
        this.args = Arrays.isNullOrEmpty(args) ? null : (Object[])args.clone();
    }

    @Override
    public String value() {
        return Strings.formatIfArgs(this.value, this.args);
    }

    public int hashCode() {
        return 31 + Objects.hashCodeFor(this.value) + Objects.hashCodeFor(this.args);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDescription other = (TextDescription)obj;
        return Objects.areEqual(this.value, other.value) && Objects.areEqual(this.args, other.args);
    }
}

