/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation;

import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.ParameterDescriptor;
import jakarta.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation.Cascaded;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class DisabledCascadedValidationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)DisabledCascadedValidationTest.webArchiveBuilder().withTestClass(DisabledCascadedValidationTest.class)).withClass(Cascaded.class)).withValidationXml("validation-DisabledCascadedValidationTest.xml")).withResource("DisabledCascadedValidationTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-methodleveloverriding", id="o")
    public void testValidAnnotationIsIgnored() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(Cascaded.class, "cascade", String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Assert.assertFalse((boolean)returnValueDescriptor.isCascaded(), (String)"Cascaded validation should be ignored");
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)descriptor.getParameterDescriptors().get(0);
        Assert.assertFalse((boolean)parameterDescriptor.isCascaded(), (String)"Cascaded validation should be ignored");
    }
}

