/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Throwables;

public class ShouldBeInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeInstance(Object object, Class<?> type) {
        return object instanceof Throwable ? new ShouldBeInstance((Throwable)object, type) : new ShouldBeInstance(object, type);
    }

    public static ErrorMessageFactory shouldBeInstanceButWasNull(String objectDescription, Class<?> type) {
        return new ShouldBeInstance(objectDescription, type);
    }

    private ShouldBeInstance(Object object, Class<?> type) {
        super("%nExpecting:%n  <%s>%nto be an instance of:%n  <%s>%nbut was instance of:%n  <%s>", object, type, object.getClass());
    }

    private ShouldBeInstance(Throwable throwable, Class<?> type) {
        super("%nExpecting:%n  <%s>%nto be an instance of:%n  <%s>%nbut was:%n  <%s>", throwable, type, Throwables.getStackTrace(throwable));
    }

    private ShouldBeInstance(String objectDescription, Class<?> type) {
        super("%nExpecting object:%n  %s%nto be an instance of:%n  <%s>%nbut was null", objectDescription, type);
    }
}

