/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer.tar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.StreamImporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.tar.TarEntry;
import org.jboss.shrinkwrap.impl.base.io.tar.TarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TarImporterBase<S extends TarInputStream, I extends StreamImporter<I>>
extends AssignableBase<Archive<?>>
implements StreamImporter<I> {
    private static final Logger log = Logger.getLogger(TarImporterBase.class.getName());

    public TarImporterBase(Archive<?> archive) {
        super(archive);
    }

    abstract Class<I> getActualClass();

    abstract S getInputStreamForRawStream(InputStream var1) throws IOException;

    private I covarientReturn() {
        return (I)((StreamImporter)this.getActualClass().cast(this));
    }

    public I importFrom(InputStream stream) throws ArchiveImportException {
        return this.importFrom((S)stream, (Filter<ArchivePath>)Filters.includeAll());
    }

    public I importFrom(InputStream stream, Filter<ArchivePath> filter) throws ArchiveImportException {
        S tarStream;
        Validate.notNull(stream, "Stream must be specified");
        Validate.notNull(filter, "Filter must be specified");
        try {
            tarStream = this.getInputStreamForRawStream(stream);
        }
        catch (RuntimeException re) {
            throw new ArchiveImportException("Could not wrap raw input with TAR stream", (Throwable)re);
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not wrap raw input with TAR stream", (Throwable)e);
        }
        return this.importFrom(tarStream, filter);
    }

    private I importFrom(S stream, Filter<ArchivePath> filter) throws ArchiveImportException {
        Validate.notNull(stream, "Stream must be specified");
        try {
            TarEntry entry;
            while ((entry = ((TarInputStream)stream).getNextEntry()) != null) {
                int readBytes;
                String entryName = entry.getName();
                if (!filter.include((Object)ArchivePaths.create((String)entryName))) continue;
                Object archive = this.getArchive();
                if (entry.isDirectory()) {
                    archive.addAsDirectory(entryName);
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
                byte[] content = new byte[4096];
                while ((readBytes = ((TarInputStream)stream).read(content, 0, content.length)) != -1) {
                    output.write(content, 0, readBytes);
                }
                archive.add((Asset)new ByteArrayAsset(output.toByteArray()), entryName);
            }
        }
        catch (RuntimeException re) {
            throw new ArchiveImportException("Could not import stream", (Throwable)re);
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not import stream", (Throwable)e);
        }
        return this.covarientReturn();
    }

    public I importFrom(File file) throws ArchiveImportException {
        return this.importFrom(file, (Filter<ArchivePath>)Filters.includeAll());
    }

    public I importFrom(File file, Filter<ArchivePath> filter) throws ArchiveImportException {
        S archive;
        Validate.notNull(file, "File must be specified");
        if (!file.exists()) {
            throw new IllegalArgumentException("Specified file for import does not exist: " + file);
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Specified file for import is a directory: " + file);
        }
        try {
            archive = this.getInputStreamForFile(file);
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not read archive file " + file, (Throwable)e);
        }
        return this.importFrom(archive, filter);
    }

    private S getInputStreamForFile(File file) throws IOException {
        assert (file != null) : "File must be specified";
        return this.getInputStreamForRawStream(new FileInputStream(file));
    }
}

