/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider;

import jakarta.validation.ParameterNameProvider;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.BrokenCustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class DefaultParameterNameProviderTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)DefaultParameterNameProviderTest.webArchiveBuilder().withTestClass(DefaultParameterNameProviderTest.class)).withClasses(BrokenCustomParameterNameProvider.class, User.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-namingparameters", id="a")
    public void testDefaultParameterProviderForMethod() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setNames", String.class, String.class);
        Object[] parameters = new Object[]{null, null};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameters, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setNames").parameter("firstName", 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setNames").parameter("lastName", 1)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-namingparameters", id="a")
    public void testDefaultParameterProviderForConstructor() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, String.class, Date.class);
        Object[] parameters = new Object[]{null, null, null};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, parameters, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("firstName", 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("lastName", 1)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("dateOfBirth", 2)));
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="d")
    public void testGetDefaultParameterNameProviderFromConfiguration() throws Exception {
        Method method = User.class.getMethod("setNames", String.class, String.class);
        Constructor constructor = User.class.getConstructor(String.class, String.class, Date.class);
        ParameterNameProvider defaultParameterNameProvider = TestUtil.getConfigurationUnderTest().getDefaultParameterNameProvider();
        Assert.assertNotNull((Object)defaultParameterNameProvider, (String)"getDefaultParameterNameProvider() must not return null");
        Assert.assertEquals((Collection)defaultParameterNameProvider.getParameterNames(constructor), Arrays.asList("firstName", "lastName", "dateOfBirth"), (String)"Wrong constructor parameter names returned by default provider");
        Assert.assertEquals((Collection)defaultParameterNameProvider.getParameterNames(method), Arrays.asList("firstName", "lastName"), (String)"Wrong method parameter names returned by default provider");
    }
}

