/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class NullNotNullConstraintsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NullNotNullConstraintsTest.webArchiveBuilder().withTestClass(NullNotNullConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-null", id="a")})
    public void testNullConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NullDummyEntity dummy = new NullDummyEntity();
        Object foo = new Object();
        dummy.setProperty(foo);
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Null.class).withProperty("property").withInvalidValue(foo).withRootBeanClass(NullDummyEntity.class));
        dummy.setProperty(null);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-notnull", id="a")})
    public void testNotNullConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NotNullDummyEntity dummy = new NotNullDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("property").withInvalidValue(null).withRootBeanClass(NotNullDummyEntity.class));
        dummy.setProperty(new Object());
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static class NotNullDummyEntity {
        @NotNull
        private Object property;

        private NotNullDummyEntity() {
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }

    private static class NullDummyEntity {
        @Null
        private Object property;

        private NullDummyEntity() {
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }
}

