/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.ClockProvider;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class FuturePastConstraintsTest
extends AbstractTCKTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)FuturePastConstraintsTest.webArchiveBuilder().withTestClass(FuturePastConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-past", id="a")})
    public void testPastConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PastDummyEntity dummy = new PastDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        ZonedDateTime reference = ZonedDateTime.now(TZ_BERLIN);
        ZonedDateTime future = reference.plusYears(1L).plusMonths(1L).plusHours(1L);
        dummy = new PastDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Past.class).withProperty("date"), ConstraintViolationAssert.violationOf(Past.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(Past.class).withProperty("instant"), ConstraintViolationAssert.violationOf(Past.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(Past.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(Past.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("year"), ConstraintViolationAssert.violationOf(Past.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(Past.class).withProperty("zonedDateTime"));
        ZonedDateTime past = reference.minusYears(1L).minusMonths(1L).minusHours(1L);
        dummy = new PastDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-past", id="a")})
    public void testPastConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 0, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        PastRelativePartialDummyEntity dummy = new PastRelativePartialDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        ZonedDateTime future = reference.plusMonths(1L).plusHours(1L);
        dummy = new PastRelativePartialDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Past.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(Past.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(Past.class).withProperty("offsetTime"));
        ZonedDateTime past = reference.minusMonths(1L).minusHours(1L);
        dummy = new PastRelativePartialDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-future", id="a")})
    public void testFutureConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        FutureDummyEntity dummy = new FutureDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        ZonedDateTime reference = ZonedDateTime.now(TZ_BERLIN);
        ZonedDateTime past = reference.minusYears(1L).minusMonths(1L).minusHours(1L);
        dummy = new FutureDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Future.class).withProperty("date"), ConstraintViolationAssert.violationOf(Future.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(Future.class).withProperty("instant"), ConstraintViolationAssert.violationOf(Future.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("year"), ConstraintViolationAssert.violationOf(Future.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(Future.class).withProperty("zonedDateTime"));
        ZonedDateTime future = reference.plusYears(1L).plusMonths(1L).plusHours(1L);
        dummy = new FutureDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-future", id="a")})
    public void testFutureConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 0, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        FutureRelativePartialDummyEntity dummy = new FutureRelativePartialDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        ZonedDateTime past = reference.minusMonths(1L).minusHours(1L);
        dummy = new FutureRelativePartialDummyEntity(past);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Future.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(Future.class).withProperty("offsetTime"));
        ZonedDateTime future = reference.plusMonths(1L).plusHours(1L);
        dummy = new FutureRelativePartialDummyEntity(future);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="builtinconstraints-pastorpresent", id="a")
    public void testPastOrPresentConstraint() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        PastDummyEntity pastDummy = new PastDummyEntity(reference);
        Set pastConstraintViolations = validator.validate((Object)pastDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(pastConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Past.class).withProperty("date"), ConstraintViolationAssert.violationOf(Past.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(Past.class).withProperty("instant"), ConstraintViolationAssert.violationOf(Past.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(Past.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(Past.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(Past.class).withProperty("year"), ConstraintViolationAssert.violationOf(Past.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(Past.class).withProperty("zonedDateTime"));
        PastOrPresentDummyEntity pastOrPresentDummy = new PastOrPresentDummyEntity();
        Set pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(pastOrPresentConstraintViolations);
        pastOrPresentDummy = new PastOrPresentDummyEntity(reference);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(pastOrPresentConstraintViolations);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 5, 5, 13, 14, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentDummyEntity(pastDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(pastOrPresentConstraintViolations);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentDummyEntity(futureDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(pastOrPresentConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("date"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("instant"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("year"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("zonedDateTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-pastorpresent", id="a")
    public void testPastOrPresentConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        PastRelativePartialDummyEntity pastDummy = new PastRelativePartialDummyEntity(reference);
        Set pastConstraintViolations = validator.validate((Object)pastDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(pastConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Past.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(Past.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(Past.class).withProperty("offsetTime"));
        PastOrPresentRelativePartialDummyEntity pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity();
        Set pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(pastOrPresentConstraintViolations);
        pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity(reference);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(pastOrPresentConstraintViolations);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 5, 5, 13, 14, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity(pastDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(pastOrPresentConstraintViolations);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        pastOrPresentDummy = new PastOrPresentRelativePartialDummyEntity(futureDate);
        pastOrPresentConstraintViolations = validator.validate((Object)pastOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(pastOrPresentConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(PastOrPresent.class).withProperty("offsetTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-futureorpresent", id="a")
    public void testFutureOrPresentConstraint() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        FutureDummyEntity futureDummy = new FutureDummyEntity(reference);
        Set futureConstraintViolations = validator.validate((Object)futureDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(futureConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Future.class).withProperty("date"), ConstraintViolationAssert.violationOf(Future.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(Future.class).withProperty("instant"), ConstraintViolationAssert.violationOf(Future.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("year"), ConstraintViolationAssert.violationOf(Future.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(Future.class).withProperty("zonedDateTime"));
        FutureOrPresentDummyEntity futureOrPresentDummy = new FutureOrPresentDummyEntity();
        Set futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(futureOrPresentConstraintViolations);
        futureOrPresentDummy = new FutureOrPresentDummyEntity(reference);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(futureOrPresentConstraintViolations);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentDummyEntity(futureDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(futureOrPresentConstraintViolations);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 4, 3, 12, 20, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentDummyEntity(pastDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(futureOrPresentConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("date"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("instant"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("year"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("zonedDateTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-futureorpresent", id="a")
    public void testFutureOrPresentConstraintForRelativePartial() {
        ZonedDateTime reference = ZonedDateTime.of(2016, 6, 6, 14, 26, 0, 0, TZ_BERLIN);
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(reference)).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        FutureRelativePartialDummyEntity futureDummy = new FutureRelativePartialDummyEntity(reference);
        Set futureConstraintViolations = validator.validate((Object)futureDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(futureConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Future.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(Future.class).withProperty("offsetTime"));
        FutureOrPresentRelativePartialDummyEntity futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity();
        Set futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(futureOrPresentConstraintViolations);
        futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity(reference);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(futureOrPresentConstraintViolations);
        ZonedDateTime futureDate = ZonedDateTime.of(2017, 7, 7, 15, 32, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity(futureDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(futureOrPresentConstraintViolations);
        ZonedDateTime pastDate = ZonedDateTime.of(2015, 4, 3, 12, 20, 0, 0, TZ_BERLIN);
        futureOrPresentDummy = new FutureOrPresentRelativePartialDummyEntity(pastDate);
        futureOrPresentConstraintViolations = validator.validate((Object)futureOrPresentDummy, new Class[0]);
        ConstraintViolationAssert.assertThat(futureOrPresentConstraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(FutureOrPresent.class).withProperty("offsetTime"));
    }

    private static class FixedClockProvider
    implements ClockProvider {
        private final Clock clock;

        public FixedClockProvider(ZonedDateTime dateTime) {
            this.clock = Clock.fixed(dateTime.toInstant(), dateTime.getZone());
        }

        public Clock getClock() {
            return this.clock;
        }
    }

    private static class FutureOrPresentRelativePartialDummyEntity {
        @FutureOrPresent
        private LocalTime localTime;
        @FutureOrPresent
        private MonthDay monthDay;
        @FutureOrPresent
        private OffsetTime offsetTime;

        public FutureOrPresentRelativePartialDummyEntity() {
        }

        public FutureOrPresentRelativePartialDummyEntity(ZonedDateTime dateTime) {
            this.localTime = dateTime.toLocalTime();
            this.monthDay = MonthDay.from(dateTime);
            this.offsetTime = OffsetTime.from(dateTime);
        }
    }

    public class FutureRelativePartialDummyEntity {
        @Future
        private LocalTime localTime;
        @Future
        private MonthDay monthDay;
        @Future
        private OffsetTime offsetTime;

        public FutureRelativePartialDummyEntity() {
        }

        public FutureRelativePartialDummyEntity(ZonedDateTime dateTime) {
            this.localTime = dateTime.toLocalTime();
            this.monthDay = MonthDay.from(dateTime);
            this.offsetTime = OffsetTime.from(dateTime);
        }
    }

    private static class FutureOrPresentDummyEntity {
        @FutureOrPresent
        private Calendar calendar;
        @FutureOrPresent
        private Date date;
        @FutureOrPresent
        private HijrahDate hijrahDate;
        @FutureOrPresent
        private Instant instant;
        @FutureOrPresent
        private JapaneseDate japaneseDate;
        @FutureOrPresent
        private LocalDate localDate;
        @FutureOrPresent
        private LocalDateTime localDateTime;
        @FutureOrPresent
        private MinguoDate minguoDate;
        @FutureOrPresent
        private OffsetDateTime offsetDateTime;
        @FutureOrPresent
        private ThaiBuddhistDate thaiBuddhistDate;
        @FutureOrPresent
        private Year year;
        @FutureOrPresent
        private YearMonth yearMonth;
        @FutureOrPresent
        private ZonedDateTime zonedDateTime;

        private FutureOrPresentDummyEntity() {
        }

        private FutureOrPresentDummyEntity(ZonedDateTime dateTime) {
            this.calendar = GregorianCalendar.from(dateTime);
            this.date = this.calendar.getTime();
            this.instant = dateTime.toInstant();
            this.localDateTime = dateTime.toLocalDateTime();
            this.hijrahDate = HijrahDate.from(dateTime);
            this.japaneseDate = JapaneseDate.from(dateTime);
            this.localDate = LocalDate.from(dateTime);
            this.minguoDate = MinguoDate.from(dateTime);
            this.offsetDateTime = dateTime.toOffsetDateTime();
            this.thaiBuddhistDate = ThaiBuddhistDate.from(dateTime);
            this.year = Year.from(dateTime);
            this.yearMonth = YearMonth.from(dateTime);
            this.zonedDateTime = dateTime;
        }
    }

    public class FutureDummyEntity {
        @Future
        private Calendar calendar;
        @Future
        private Date date;
        @Future
        private HijrahDate hijrahDate;
        @Future
        private Instant instant;
        @Future
        private JapaneseDate japaneseDate;
        @Future
        private LocalDate localDate;
        @Future
        private LocalDateTime localDateTime;
        @Future
        private MinguoDate minguoDate;
        @Future
        private OffsetDateTime offsetDateTime;
        @Future
        private ThaiBuddhistDate thaiBuddhistDate;
        @Future
        private Year year;
        @Future
        private YearMonth yearMonth;
        @Future
        private ZonedDateTime zonedDateTime;

        public FutureDummyEntity() {
        }

        public FutureDummyEntity(ZonedDateTime dateTime) {
            this.calendar = GregorianCalendar.from(dateTime);
            this.date = this.calendar.getTime();
            this.instant = dateTime.toInstant();
            this.localDateTime = dateTime.toLocalDateTime();
            this.hijrahDate = HijrahDate.from(dateTime);
            this.japaneseDate = JapaneseDate.from(dateTime);
            this.localDate = LocalDate.from(dateTime);
            this.minguoDate = MinguoDate.from(dateTime);
            this.offsetDateTime = dateTime.toOffsetDateTime();
            this.thaiBuddhistDate = ThaiBuddhistDate.from(dateTime);
            this.year = Year.from(dateTime);
            this.yearMonth = YearMonth.from(dateTime);
            this.zonedDateTime = dateTime;
        }
    }

    private static class PastOrPresentRelativePartialDummyEntity {
        @PastOrPresent
        private LocalTime localTime;
        @PastOrPresent
        private MonthDay monthDay;
        @PastOrPresent
        private OffsetTime offsetTime;

        public PastOrPresentRelativePartialDummyEntity() {
        }

        public PastOrPresentRelativePartialDummyEntity(ZonedDateTime dateTime) {
            this.localTime = dateTime.toLocalTime();
            this.monthDay = MonthDay.from(dateTime);
            this.offsetTime = OffsetTime.from(dateTime);
        }
    }

    public class PastRelativePartialDummyEntity {
        @Past
        private LocalTime localTime;
        @Past
        private MonthDay monthDay;
        @Past
        private OffsetTime offsetTime;

        public PastRelativePartialDummyEntity() {
        }

        public PastRelativePartialDummyEntity(ZonedDateTime dateTime) {
            this.localTime = dateTime.toLocalTime();
            this.monthDay = MonthDay.from(dateTime);
            this.offsetTime = OffsetTime.from(dateTime);
        }
    }

    private static class PastOrPresentDummyEntity {
        @PastOrPresent
        private Calendar calendar;
        @PastOrPresent
        private Date date;
        @PastOrPresent
        private HijrahDate hijrahDate;
        @PastOrPresent
        private Instant instant;
        @PastOrPresent
        private JapaneseDate japaneseDate;
        @PastOrPresent
        private LocalDate localDate;
        @PastOrPresent
        private LocalDateTime localDateTime;
        @PastOrPresent
        private MinguoDate minguoDate;
        @PastOrPresent
        private OffsetDateTime offsetDateTime;
        @PastOrPresent
        private ThaiBuddhistDate thaiBuddhistDate;
        @PastOrPresent
        private Year year;
        @PastOrPresent
        private YearMonth yearMonth;
        @PastOrPresent
        private ZonedDateTime zonedDateTime;

        public PastOrPresentDummyEntity() {
        }

        public PastOrPresentDummyEntity(ZonedDateTime dateTime) {
            this.calendar = GregorianCalendar.from(dateTime);
            this.date = this.calendar.getTime();
            this.instant = dateTime.toInstant();
            this.localDateTime = dateTime.toLocalDateTime();
            this.hijrahDate = HijrahDate.from(dateTime);
            this.japaneseDate = JapaneseDate.from(dateTime);
            this.localDate = LocalDate.from(dateTime);
            this.minguoDate = MinguoDate.from(dateTime);
            this.offsetDateTime = dateTime.toOffsetDateTime();
            this.thaiBuddhistDate = ThaiBuddhistDate.from(dateTime);
            this.year = Year.from(dateTime);
            this.yearMonth = YearMonth.from(dateTime);
            this.zonedDateTime = dateTime;
        }
    }

    public class PastDummyEntity {
        @Past
        private Calendar calendar;
        @Past
        private Date date;
        @Past
        private HijrahDate hijrahDate;
        @Past
        private Instant instant;
        @Past
        private JapaneseDate japaneseDate;
        @Past
        private LocalDate localDate;
        @Past
        private LocalDateTime localDateTime;
        @Past
        private MinguoDate minguoDate;
        @Past
        private OffsetDateTime offsetDateTime;
        @Past
        private ThaiBuddhistDate thaiBuddhistDate;
        @Past
        private Year year;
        @Past
        private YearMonth yearMonth;
        @Past
        private ZonedDateTime zonedDateTime;

        public PastDummyEntity() {
        }

        public PastDummyEntity(ZonedDateTime dateTime) {
            this.calendar = GregorianCalendar.from(dateTime);
            this.date = this.calendar.getTime();
            this.instant = dateTime.toInstant();
            this.localDateTime = dateTime.toLocalDateTime();
            this.hijrahDate = HijrahDate.from(dateTime);
            this.japaneseDate = JapaneseDate.from(dateTime);
            this.localDate = LocalDate.from(dateTime);
            this.minguoDate = MinguoDate.from(dateTime);
            this.offsetDateTime = dateTime.toOffsetDateTime();
            this.thaiBuddhistDate = ThaiBuddhistDate.from(dateTime);
            this.year = Year.from(dateTime);
            this.yearMonth = YearMonth.from(dateTime);
            this.zonedDateTime = dateTime;
        }
    }
}

