/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.ResizeableDialogBase;
import org.eclipse.emf.edapt.history.instantiation.ReplaceCommand;
import org.eclipse.emf.edapt.history.instantiation.ui.OperationSash;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.internal.common.IExtentProvider;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ReplaceDialog
extends ResizeableDialogBase {
    private final List<PrimitiveChange> changes;
    private OperationSash operationSash;
    private EcoreForwardReconstructor reconstructor;
    private ModelSash metamodelSash;
    private ReplaceCommand command;

    public ReplaceDialog(List<PrimitiveChange> changes) {
        super(new Point(1024, 768), "Replace primitive changes with operation", "A sequence of primitive changes can be replaced by the instantiation of an operation. On the left-hand side, the state of the metamodel before the primitive changes is shown. In the middle, the sequence of primitive changes is shown. An element can be located in the metamodel by double-clicking on a property of a primitive change. On the right-hand side, the operations viewer allows to instantiate the operation.");
        this.changes = changes;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.initMetamodelSash(sash);
        this.initChangeSash(sash);
        this.initOperationSash(sash);
        sash.setWeights(new int[]{1, 1, 1});
        return parent;
    }

    private void initOperationSash(SashForm sash) {
        final MetamodelExtent extent = new MetamodelExtent(MetamodelUtils.getAllRootPackages((ResourceSet)this.reconstructor.getResourceSet()));
        IExtentProvider provider = new IExtentProvider(){

            public MetamodelExtent getExtent() {
                return extent;
            }
        };
        this.operationSash = new OperationSash((Composite)sash, provider){

            @Override
            protected boolean updateConstraints(OperationInstance operationInstance) {
                boolean valid = super.updateConstraints(operationInstance);
                if (valid) {
                    ReplaceDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReplaceDialog.this.getButton(0).setEnabled(false);
                }
                return valid;
            }
        };
        this.metamodelSash.getStructureViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReplaceDialog.this.operationSash.updateOperations((IStructuredSelection)event.getSelection());
                ReplaceDialog.this.getButton(0).setEnabled(false);
            }
        });
    }

    private void initChangeSash(SashForm sash) {
        ModelSash changeSash = new ModelSash((Composite)sash, 0){

            protected void propertyValuesSelected(Object value) {
                EObject target;
                if (value instanceof EObject && (target = ReplaceDialog.this.reconstructor.getMapping().getTarget((EObject)value)) != null) {
                    StructuredSelection selection = new StructuredSelection((Object)target);
                    ReplaceDialog.this.metamodelSash.getStructureViewer().setSelection((ISelection)selection, true);
                }
            }
        };
        changeSash.getStructureViewer().setInput((Object)this.changes.get(0).eContainer());
        changeSash.getStructureViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                EObject eObject = (EObject)element;
                return ReplaceDialog.this.changes.contains(element) || !(eObject.eContainer() instanceof Release);
            }
        });
        changeSash.getStructureViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EObject target;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object value = selection.getFirstElement();
                if (value instanceof EObject && (target = ReplaceDialog.this.reconstructor.getMapping().getTarget((EObject)value)) != null) {
                    StructuredSelection newSelection = new StructuredSelection((Object)target);
                    ReplaceDialog.this.metamodelSash.getStructureViewer().setSelection((ISelection)newSelection, true);
                }
            }
        });
        changeSash.getStructureViewer().setSorter(null);
    }

    private void initMetamodelSash(SashForm sash) {
        this.reconstructor = new EcoreForwardReconstructor(URI.createFileURI((String)"recons"));
        this.reconstructor.reconstruct((Change)this.changes.get(0), true);
        this.metamodelSash = new ModelSash((Composite)sash, 0);
        this.metamodelSash.getStructureViewer().setInput((Object)this.reconstructor.getResourceSet());
    }

    protected void okPressed() {
        OperationInstance operation = (OperationInstance)this.reconstructor.getMapping().copyResolveSource((EObject)this.operationSash.getSelectedOperation());
        this.command = new ReplaceCommand(this.changes, operation);
        if (this.command.canExecute()) {
            super.okPressed();
        } else {
            String title = "Primitive changes cannot be replaced by operation";
            String string = "The primitive changes cannot be replaced by the instantiation of the operation. The differences between the state of the metamodel after the primitive changes and the state of the metamodel after the instantiation of the operation is shown below.";
        }
    }

    public ReplaceCommand getReplaceCommand() {
        return this.command;
    }
}

