/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edapt.common.ui.EcoreUIUtils;
import org.eclipse.emf.edapt.common.ui.PartAdapter;
import org.eclipse.emf.edapt.history.presentation.HistoryEditorPlugin;
import org.eclipse.emf.edapt.history.recorder.AddResourceCommand;
import org.eclipse.emf.edapt.history.recorder.EditingDomainListener;
import org.eclipse.emf.edapt.history.recorder.IResourceLoadListener;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class EcoreEditorDetector
extends PartAdapter
implements IPropertyListener {
    private final Map<EcoreEditor, EditingDomainListener> mapping;
    private static EcoreEditorDetector instance = new EcoreEditorDetector();

    public static EcoreEditorDetector getInstance() {
        return instance;
    }

    private EcoreEditorDetector() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.addPartListener((IPartListener)this);
        this.mapping = new HashMap<EcoreEditor, EditingDomainListener>();
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        int i = 0;
        int n = editorReferences.length;
        while (i < n) {
            IEditorReference editorReference = editorReferences[i];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor instanceof EcoreEditor) {
                EcoreEditor ecoreEditor = (EcoreEditor)editor;
                this.addEditor(ecoreEditor);
            }
            ++i;
        }
    }

    public void addEditor(final EcoreEditor editor) {
        IRunnableWithProgress attachRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                EditingDomainListener listener = EcoreEditorDetector.this.getListener(editor);
                if (listener == null) {
                    listener = new EditingDomainListener(editor.getEditingDomain());
                }
                if (listener.loadHistory()) {
                    EcoreEditorDetector.this.validateListener(editor, listener);
                }
            }
        };
        try {
            new ProgressMonitorDialog(editor.getSite().getShell()).run(true, false, attachRunnable);
        }
        catch (InvocationTargetException ex) {
            LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)ex);
        }
    }

    public void addEditorAndCreateHistory(EcoreEditor editor, List<Resource> metamodelResources, URI historyURI) {
        EditingDomainListener listener = this.getListener(editor);
        if (listener == null) {
            listener = new EditingDomainListener(editor.getEditingDomain());
            listener.createHistory(metamodelResources, historyURI);
            this.validateListener(editor, listener);
        }
    }

    void validateListener(EcoreEditor editor, final EditingDomainListener listener) {
        this.mapping.put(editor, listener);
        editor.addPropertyListener((IPropertyListener)this);
        this.hackAdapterFactory(editor);
        if (listener.isListening()) {
            listener.endListening();
        }
        listener.beginListening();
        listener.addResourceListener(new IResourceLoadListener(){

            public void resourceLoaded(Resource resource) {
                EcoreEditorDetector.this.addHistory(listener, resource);
            }
        });
    }

    private void addHistory(EditingDomainListener listener, Resource resource) {
        boolean addHistory = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Resource loaded", (String)"A resource has been loaded. Do you want to add it to the history?");
        if (addHistory) {
            CommandStack commandStack = listener.getEditingDomain().getCommandStack();
            commandStack.execute((Command)new AddResourceCommand(listener, resource));
        }
    }

    private void hackAdapterFactory(EcoreEditor editor) {
        ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)editor.getAdapterFactory();
        AdapterFactory adapterFactory = composedAdapterFactory.getFactoryForType((Object)HistoryPackage.eINSTANCE.getHistory());
        if (adapterFactory instanceof ReflectiveItemProviderAdapterFactory) {
            composedAdapterFactory.removeAdapterFactory(adapterFactory);
            composedAdapterFactory.addAdapterFactory((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        }
    }

    private void removeEditor(EcoreEditor editor) {
        EditingDomainListener listener = this.mapping.get(editor);
        if (listener != null) {
            listener.endListening();
            editor.removePropertyListener((IPropertyListener)this);
        }
        this.mapping.remove(editor);
    }

    public void partOpened(IWorkbenchPart part) {
        EcoreEditor editor;
        if (part instanceof EcoreEditor && EcoreUIUtils.isMetamodelEditor((EcoreEditor)(editor = (EcoreEditor)part))) {
            this.addEditor(editor);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof EcoreEditor) {
            EcoreEditor editor = (EcoreEditor)part;
            this.removeEditor(editor);
        }
    }

    public EditingDomainListener getListener(EcoreEditor editor) {
        return this.mapping.get(editor);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            EcoreEditor editor = (EcoreEditor)source;
            EditingDomainListener listener = this.mapping.get(editor);
            listener.resetRecorder();
        }
    }
}

