/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.edapt.history.instantiation.ReleaseCommand;
import org.eclipse.emf.edapt.history.instantiation.UpdatePackageNamespaceCommand;
import org.eclipse.emf.edapt.history.instantiation.ui.EditingDomainListenerHandlerBase;
import org.eclipse.emf.edapt.history.instantiation.ui.ReleaseWizard;
import org.eclipse.emf.edapt.history.presentation.HistoryEditorPlugin;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.recorder.EditingDomainListener;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.ContentChange;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.ValueChange;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReleaseHandler
extends EditingDomainListenerHandlerBase {
    @Override
    protected Object execute(EditingDomainListener listener, EcoreEditor editor) {
        MetamodelExtent extent = listener.getExtent();
        if (this.isConsistent(extent)) {
            this.release(extent, listener);
        }
        return null;
    }

    private boolean isConsistent(MetamodelExtent extent) {
        if (extent.isConsistent()) {
            return true;
        }
        boolean ignore = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Metamodel inconsistent", (String)"The metamodel is inconsistent. Do you really want to release it?");
        return ignore;
    }

    private void release(MetamodelExtent extent, EditingDomainListener listener) {
        try {
            EditingDomain domain = listener.getEditingDomain();
            if (!this.isNsURIChanged(extent, listener.getHistory().getLastRelease())) {
                History history = listener.getHistory();
                EList rootPackages = history.getRootPackages();
                Set<EPackage> changedPackages = this.getChangedPackages(history.getLastRelease());
                ReleaseWizard releaseWizard = new ReleaseWizard((List<EPackage>)rootPackages, changedPackages);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)releaseWizard);
                if (dialog.open() == 0) {
                    for (EPackage ePackage : rootPackages) {
                        if (!releaseWizard.updatePackage(ePackage)) continue;
                        String source = releaseWizard.getSource(ePackage);
                        String target = releaseWizard.getTarget(ePackage);
                        this.updateNamespaceURI(domain, Collections.singletonList(ePackage), source, target);
                    }
                    this.addRelease(domain, listener, null);
                }
            } else {
                this.addRelease(domain, listener, null);
            }
        }
        catch (InvocationTargetException ex) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error during release", (String)"An error occurred during the release. Did you record all changes?", (IStatus)LoggingUtils.createMultiStatus((Plugin)HistoryEditorPlugin.getPlugin(), (int)4, (String)"Exception during reconstruction...", (Throwable)ex.getTargetException()));
        }
    }

    private Set<EPackage> getChangedPackages(Release lastRelease) {
        LinkedHashSet<EPackage> packages = new LinkedHashSet<EPackage>();
        if (lastRelease == null) {
            return packages;
        }
        EList changes = lastRelease.getChanges();
        this.collectPackagesFromChanges(packages, (List<Change>)changes);
        return packages;
    }

    private void collectPackagesFromChanges(Set<EPackage> packages, List<Change> changes) {
        for (Change change : changes) {
            EObject target = null;
            if (ContentChange.class.isInstance(change)) {
                target = ((ContentChange)ContentChange.class.cast(change)).getTarget();
            } else if (ValueChange.class.isInstance(change)) {
                target = ((ValueChange)ValueChange.class.cast(change)).getElement();
            }
            if (target != null) {
                EObject eP = target.eContainer();
                while (eP != null) {
                    if (EPackage.class.isInstance(eP)) {
                        packages.add((EPackage)eP);
                        break;
                    }
                    eP = eP.eContainer();
                }
            }
            if (!CompositeChange.class.isInstance(change)) continue;
            ArrayList<Change> childChanges = new ArrayList<Change>((Collection<Change>)((CompositeChange)CompositeChange.class.cast(change)).getChanges());
            this.collectPackagesFromChanges(packages, childChanges);
        }
    }

    private void updateNamespaceURI(EditingDomain domain, List<EPackage> rootPackages, String source, String target) {
        UpdatePackageNamespaceCommand command = new UpdatePackageNamespaceCommand(rootPackages, source, target);
        domain.getCommandStack().execute((Command)command);
    }

    private void addRelease(EditingDomain domain, EditingDomainListener listener, String target) {
        ReleaseCommand command = new ReleaseCommand(listener, target);
        domain.getCommandStack().execute((Command)command);
    }

    private boolean isNsURIChanged(MetamodelExtent extent, Release release) throws InvocationTargetException {
        EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createURI((String)"before"));
        try {
            reconstructor.reconstruct(release, true);
        }
        catch (RuntimeException ex) {
            throw new InvocationTargetException(ex);
        }
        return this.isNsURIChanged(extent.getRootPackages(), reconstructor);
    }

    private boolean isNsURIChanged(Collection<EPackage> packages, EcoreForwardReconstructor reconstructor) {
        for (EPackage now : packages) {
            EPackage before = (EPackage)reconstructor.getMapping().getTarget((EObject)now);
            if (before != null && now.getNsURI().equals(before.getNsURI())) {
                return false;
            }
            if (this.isNsURIChanged((Collection<EPackage>)now.getESubpackages(), reconstructor)) continue;
            return false;
        }
        return true;
    }
}

