/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<E> {
    private List<E> elements = new ArrayList();
    private Map<E, Set<E>> incoming = new HashMap<E, Set<E>>();
    private Map<E, Set<E>> outgoing = new HashMap<E, Set<E>>();

    public DirectedGraph() {
    }

    public DirectedGraph(Collection<E> elements) {
        this();
        for (E element : elements) {
            this.add(element);
        }
    }

    public void add(E element) {
        if (!this.elements.contains(element)) {
            this.elements.add(element);
            this.incoming.put(element, new HashSet());
            this.outgoing.put(element, new HashSet());
        }
    }

    public void remove(E element) {
        if (this.elements.remove(element)) {
            for (E from : this.incoming.get(element)) {
                this.outgoing.get(from).remove(element);
            }
            for (E to : this.outgoing.get(element)) {
                this.incoming.get(to).remove(element);
            }
            this.outgoing.remove(element);
            this.incoming.remove(element);
        }
    }

    public void addOrder(E source, E target) {
        this.add(source);
        this.add(target);
        this.incoming.get(target).add(source);
        this.outgoing.get(source).add(target);
    }

    public void removeOrder(E source, E target) {
        this.incoming.get(target).remove(source);
        this.outgoing.get(source).remove(target);
    }

    public Set<E> getIncoming(E element) {
        return new HashSet(this.incoming.get(element));
    }

    public Set<E> getOutgoing(E element) {
        return new HashSet(this.outgoing.get(element));
    }

    public Set<E> getElements() {
        return new HashSet<E>(this.elements);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public E getNoIncomingElement() {
        for (E element : this.elements) {
            if (!this.getIncoming(element).isEmpty()) continue;
            return element;
        }
        return null;
    }

    public boolean contains(E element) {
        return this.elements.contains(element);
    }

    public List<E> getOrdering() {
        ArrayList<E> order = new ArrayList<E>();
        E noIncoming = this.getNoIncomingElement();
        while (noIncoming != null) {
            this.remove(noIncoming);
            order.add(noIncoming);
            noIncoming = this.getNoIncomingElement();
        }
        if (!this.isEmpty()) {
            return null;
        }
        return order;
    }
}

