/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Version;
import javax.tools.JavaFileObject;

@Version(value="@(#)DiagnosticFormatter.java\t1.11 06/04/08")
public class DiagnosticFormatter {
    protected String posFormat;
    protected String classFormat = "%f: %t%m";
    protected String noPosFormat;
    protected boolean raw;
    protected static final Context.Key<DiagnosticFormatter> formatterKey = new Context.Key();
    public static final String DEFAULT_POS_FORMAT = "%f:%l: %t%m";
    public static final String DEFAULT_CLASS_FORMAT = "%f: %t%m";
    public static final String DEFAULT_NO_POS_FORMAT = "%p%m";

    public static DiagnosticFormatter instance(Context context) {
        DiagnosticFormatter diagnosticFormatter = context.get(formatterKey);
        if (diagnosticFormatter == null) {
            diagnosticFormatter = new DiagnosticFormatter(context);
        }
        return diagnosticFormatter;
    }

    protected DiagnosticFormatter(Context context) {
        Options options = Options.instance(context);
        this.raw = options.get("rawDiagnostics") != null;
        String string = options.get("diags");
        if (string != null) {
            int n = string.indexOf(124);
            if (n == -1) {
                this.posFormat = this.noPosFormat = string;
            } else {
                this.posFormat = string.substring(0, n);
                this.noPosFormat = string.substring(n + 1);
            }
        } else {
            this.posFormat = DEFAULT_POS_FORMAT;
            this.noPosFormat = DEFAULT_NO_POS_FORMAT;
        }
    }

    public DiagnosticFormatter() {
        this.posFormat = DEFAULT_POS_FORMAT;
        this.noPosFormat = DEFAULT_NO_POS_FORMAT;
        this.raw = false;
    }

    public DiagnosticFormatter(String string, String string2) {
        this.posFormat = string;
        this.noPosFormat = string2;
        this.raw = false;
    }

    String format(JCDiagnostic jCDiagnostic) {
        return this.raw ? this.format_raw(jCDiagnostic) : this.format_std(jCDiagnostic);
    }

    private String format_raw(JCDiagnostic jCDiagnostic) {
        JCDiagnostic.DiagnosticSource diagnosticSource = jCDiagnostic.getDiagnosticSource();
        int n = jCDiagnostic.getIntPosition();
        StringBuilder stringBuilder = new StringBuilder();
        if (n == -1) {
            stringBuilder.append("-");
        } else {
            stringBuilder.append(diagnosticSource.getName() + ":" + diagnosticSource.getLineNumber(n) + ":" + diagnosticSource.getColumnNumber(n) + ":");
        }
        stringBuilder.append(" ");
        stringBuilder.append(jCDiagnostic.getCode());
        String string = ": ";
        for (Object object : jCDiagnostic.getArgs()) {
            stringBuilder.append(string);
            if (object instanceof JCDiagnostic) {
                stringBuilder.append('(');
                stringBuilder.append(this.format_raw((JCDiagnostic)object));
                stringBuilder.append(')');
            } else if (object instanceof JavaFileObject) {
                stringBuilder.append(DefaultFileManager.getJavacBaseFileName((JavaFileObject)object));
            } else {
                stringBuilder.append(object);
            }
            string = ", ";
        }
        return stringBuilder.toString();
    }

    private String format_std(JCDiagnostic jCDiagnostic) {
        JCDiagnostic.DiagnosticSource diagnosticSource = jCDiagnostic.getDiagnosticSource();
        JCDiagnostic.DiagnosticType diagnosticType = jCDiagnostic.getType();
        int n = jCDiagnostic.getIntPosition();
        String string = this.noPosFormat;
        if (diagnosticSource != null) {
            if (n != -1) {
                string = this.posFormat;
            } else if (diagnosticSource.getFile() != null && diagnosticSource.getFile().getKind() == JavaFileObject.Kind.CLASS) {
                string = this.classFormat;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        block18: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%' && i < string.length() - 1) {
                c = string.charAt(++i);
                switch (c) {
                    case 'b': {
                        stringBuilder.append(diagnosticSource == null ? "-" : diagnosticSource.getName());
                        break;
                    }
                    case 'e': {
                        stringBuilder.append(n == -1 ? "-" : String.valueOf(jCDiagnostic.getEndPosition()));
                        break;
                    }
                    case 'f': {
                        stringBuilder.append(diagnosticSource == null ? "-" : jCDiagnostic.getSourceName());
                        break;
                    }
                    case 'l': {
                        stringBuilder.append(n == -1 ? "-" : String.valueOf(jCDiagnostic.getLineNumber()));
                        break;
                    }
                    case 'c': {
                        stringBuilder.append(n == -1 ? "-" : String.valueOf(jCDiagnostic.getColumnNumber()));
                        break;
                    }
                    case 'o': {
                        stringBuilder.append(n == -1 ? "-" : String.valueOf(n));
                        break;
                    }
                    case 'p': {
                        stringBuilder.append(jCDiagnostic.getPrefix());
                        break;
                    }
                    case 's': {
                        stringBuilder.append(n == -1 ? "-" : String.valueOf(jCDiagnostic.getStartPosition()));
                        break;
                    }
                    case 't': {
                        boolean bl;
                        switch (diagnosticType) {
                            case FRAGMENT: {
                                bl = false;
                                break;
                            }
                            case ERROR: {
                                bl = n == -1;
                                break;
                            }
                            default: {
                                bl = true;
                            }
                        }
                        if (!bl) continue block18;
                        stringBuilder.append(jCDiagnostic.getPrefix());
                        break;
                    }
                    case 'm': {
                        stringBuilder.append(jCDiagnostic.getText());
                        break;
                    }
                    case '_': {
                        stringBuilder.append(' ');
                        break;
                    }
                    case '%': {
                        stringBuilder.append('%');
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

