/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.TimeComparison;
import org.apache.tools.ant.types.resources.Appendable;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Touchable;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.selectors.Date;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LineTokenizer;

public class ResourceUtils {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$FileProvider;
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$Touchable;
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$Appendable;

    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets) {
        return ResourceUtils.selectOutOfDateSources(logTo, source, mapper, targets, FILE_UTILS.getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets, long granularity) {
        Union u = new Union();
        u.addAll(Arrays.asList(source));
        ResourceCollection rc = ResourceUtils.selectOutOfDateSources(logTo, u, mapper, targets, granularity);
        return rc.size() == 0 ? new Resource[]{} : ((Union)rc).listResources();
    }

    public static ResourceCollection selectOutOfDateSources(ProjectComponent logTo, ResourceCollection source, FileNameMapper mapper, ResourceFactory targets, final long granularity) {
        ResourceUtils.logFuture(logTo, source, granularity);
        ResourceSelectorProvider p = new ResourceSelectorProvider(){

            public ResourceSelector getTargetSelectorForSource(Resource sr) {
                return new ResourceSelector(this, sr){
                    private final /* synthetic */ Resource val$sr;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$sr = val$sr;
                    }

                    public boolean isSelected(Resource target) {
                        return SelectorUtils.isOutOfDate(this.val$sr, target, 1.access$000(this.this$0));
                    }
                };
            }

            static /* synthetic */ long access$000(1 x0) {
                return x0.granularity;
            }
        };
        return ResourceUtils.selectSources(logTo, source, mapper, targets, p);
    }

    public static ResourceCollection selectSources(ProjectComponent logTo, ResourceCollection source, FileNameMapper mapper, ResourceFactory targets, ResourceSelectorProvider selector) {
        if (source.size() == 0) {
            logTo.log("No sources found.", 3);
            return Resources.NONE;
        }
        source = Union.getInstance(source);
        Union result = new Union();
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Resource sr = (Resource)iter.next();
            String srName = sr.getName();
            srName = srName == null ? srName : srName.replace('/', File.separatorChar);
            String[] targetnames = null;
            try {
                targetnames = mapper.mapFileName(srName);
            }
            catch (Exception e) {
                logTo.log("Caught " + e + " mapping resource " + sr, 3);
            }
            if (targetnames == null || targetnames.length == 0) {
                logTo.log(sr + " skipped - don't know how to handle it", 3);
                continue;
            }
            for (int i = 0; i < targetnames.length; ++i) {
                if (targetnames[i] != null) continue;
                targetnames[i] = "(no name)";
            }
            Union targetColl = new Union();
            for (int i = 0; i < targetnames.length; ++i) {
                targetColl.add(targets.getResource(targetnames[i].replace(File.separatorChar, '/')));
            }
            Restrict r = new Restrict();
            r.add(selector.getTargetSelectorForSource(sr));
            r.add(targetColl);
            if (r.size() > 0) {
                result.add(sr);
                Resource t = (Resource)r.iterator().next();
                logTo.log(sr.getName() + " added as " + t.getName() + (t.isExists() ? " is outdated." : " doesn't exist."), 3);
                continue;
            }
            logTo.log(sr.getName() + " omitted as " + targetColl.toString() + (targetColl.size() == 1 ? " is" : " are ") + " up to date.", 3);
        }
        return result;
    }

    public static void copyResource(Resource source, Resource dest) throws IOException {
        ResourceUtils.copyResource(source, dest, null);
    }

    public static void copyResource(Resource source, Resource dest, Project project) throws IOException {
        ResourceUtils.copyResource(source, dest, null, null, false, false, null, null, project);
    }

    public static void copyResource(Resource source, Resource dest, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        ResourceUtils.copyResource(source, dest, filters, filterChains, overwrite, preserveLastModified, false, inputEncoding, outputEncoding, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(Resource source, Resource dest, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, boolean append, String inputEncoding, String outputEncoding, Project project) throws IOException {
        Touchable t;
        block20: {
            Closeable in;
            block22: {
                boolean filterChainsAvailable;
                block21: {
                    if (!overwrite && !SelectorUtils.isOutOfDate(source, dest, FileUtils.getFileUtils().getFileTimestampGranularity())) {
                        return;
                    }
                    boolean filterSetsAvailable = filters != null && filters.hasFilters();
                    boolean bl = filterChainsAvailable = filterChains != null && filterChains.size() > 0;
                    if (!filterSetsAvailable) break block21;
                    in = null;
                    BufferedWriter out = null;
                    try {
                        InputStreamReader isr = null;
                        isr = inputEncoding == null ? new InputStreamReader(source.getInputStream()) : new InputStreamReader(source.getInputStream(), inputEncoding);
                        in = new BufferedReader(isr);
                        OutputStream os = ResourceUtils.getOutputStream(dest, append, project);
                        OutputStreamWriter osw = outputEncoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, outputEncoding);
                        out = new BufferedWriter(osw);
                        if (filterChainsAvailable) {
                            ChainReaderHelper crh = new ChainReaderHelper();
                            crh.setBufferSize(8192);
                            crh.setPrimaryReader((Reader)in);
                            crh.setFilterChains(filterChains);
                            crh.setProject(project);
                            Reader rdr = crh.getAssembledReader();
                            in = new BufferedReader(rdr);
                        }
                        LineTokenizer lineTokenizer = new LineTokenizer();
                        lineTokenizer.setIncludeDelims(true);
                        String newline = null;
                        String line = lineTokenizer.getToken((Reader)in);
                        while (line != null) {
                            if (line.length() == 0) {
                                out.newLine();
                            } else {
                                newline = filters.replaceTokens(line);
                                out.write(newline);
                            }
                            line = lineTokenizer.getToken((Reader)in);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(out);
                        FileUtils.close(in);
                        throw throwable;
                    }
                    FileUtils.close(out);
                    FileUtils.close((Reader)in);
                    break block20;
                }
                if (!filterChainsAvailable && (inputEncoding == null || inputEncoding.equals(outputEncoding)) && (inputEncoding != null || outputEncoding == null)) break block22;
                in = null;
                BufferedWriter out = null;
                try {
                    int nRead;
                    InputStreamReader isr = null;
                    isr = inputEncoding == null ? new InputStreamReader(source.getInputStream()) : new InputStreamReader(source.getInputStream(), inputEncoding);
                    in = new BufferedReader(isr);
                    OutputStream os = ResourceUtils.getOutputStream(dest, append, project);
                    OutputStreamWriter osw = outputEncoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, outputEncoding);
                    out = new BufferedWriter(osw);
                    if (filterChainsAvailable) {
                        ChainReaderHelper crh = new ChainReaderHelper();
                        crh.setBufferSize(8192);
                        crh.setPrimaryReader((Reader)in);
                        crh.setFilterChains(filterChains);
                        crh.setProject(project);
                        Reader rdr = crh.getAssembledReader();
                        in = new BufferedReader(rdr);
                    }
                    char[] buffer = new char[8192];
                    while ((nRead = ((BufferedReader)in).read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, nRead);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(out);
                    FileUtils.close(in);
                    throw throwable;
                }
                FileUtils.close(out);
                FileUtils.close((Reader)in);
                break block20;
            }
            if (source.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ResourceUtils.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider) != null && dest.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ResourceUtils.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider) != null) {
                File sourceFile = ((FileProvider)source.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ResourceUtils.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider)).getFile();
                File destFile = ((FileProvider)dest.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ResourceUtils.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider)).getFile();
                File parent = destFile.getParentFile();
                if (parent != null && !parent.isDirectory() && !destFile.getParentFile().mkdirs()) {
                    throw new IOException("failed to create the parent directory for " + destFile);
                }
                FileInputStream in2 = null;
                FileOutputStream out = null;
                FileChannel srcChannel = null;
                FileChannel destChannel = null;
                try {
                    in2 = new FileInputStream(sourceFile);
                    out = new FileOutputStream(destFile);
                    srcChannel = in2.getChannel();
                    destChannel = out.getChannel();
                    long count = srcChannel.size();
                    for (long position = 0L; position < count; position += srcChannel.transferTo(position, 8192L, destChannel)) {
                    }
                    Object var24_40 = null;
                }
                catch (Throwable throwable) {
                    Object var24_41 = null;
                    FileUtils.close(srcChannel);
                    FileUtils.close(destChannel);
                    FileUtils.close(out);
                    FileUtils.close(in2);
                    throw throwable;
                }
                FileUtils.close(srcChannel);
                FileUtils.close(destChannel);
                FileUtils.close(out);
                FileUtils.close(in2);
                {
                    break block20;
                }
            }
            in = null;
            OutputStream out = null;
            try {
                in = source.getInputStream();
                out = ResourceUtils.getOutputStream(dest, append, project);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = ((InputStream)in).read(buffer, 0, buffer.length)) != -1);
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                FileUtils.close((InputStream)in);
                throw throwable;
            }
            FileUtils.close(out);
            FileUtils.close((InputStream)in);
        }
        if (preserveLastModified && (t = (Touchable)dest.as(class$org$apache$tools$ant$types$resources$Touchable == null ? (class$org$apache$tools$ant$types$resources$Touchable = ResourceUtils.class$("org.apache.tools.ant.types.resources.Touchable")) : class$org$apache$tools$ant$types$resources$Touchable)) != null) {
            ResourceUtils.setLastModified(t, source.getLastModified());
        }
    }

    public static void setLastModified(Touchable t, long time) {
        t.touch(time < 0L ? System.currentTimeMillis() : time);
    }

    public static boolean contentEquals(Resource r1, Resource r2, boolean text) throws IOException {
        if (r1.isExists() != r2.isExists()) {
            return false;
        }
        if (!r1.isExists()) {
            return true;
        }
        if (r1.isDirectory() || r2.isDirectory()) {
            return false;
        }
        if (r1.equals(r2)) {
            return true;
        }
        if (!text) {
            long s1 = r1.getSize();
            long s2 = r2.getSize();
            if (s1 != -1L && s2 != -1L && s1 != s2) {
                return false;
            }
        }
        return ResourceUtils.compareContent(r1, r2, text) == 0;
    }

    public static int compareContent(Resource r1, Resource r2, boolean text) throws IOException {
        if (r1.equals(r2)) {
            return 0;
        }
        boolean e1 = r1.isExists();
        boolean e2 = r2.isExists();
        if (!e1 && !e2) {
            return 0;
        }
        if (e1 != e2) {
            return e1 ? 1 : -1;
        }
        boolean d1 = r1.isDirectory();
        boolean d2 = r2.isDirectory();
        if (d1 && d2) {
            return 0;
        }
        if (d1 || d2) {
            return d1 ? -1 : 1;
        }
        return text ? ResourceUtils.textCompare(r1, r2) : ResourceUtils.binaryCompare(r1, r2);
    }

    public static FileResource asFileResource(FileProvider fileProvider) {
        if (fileProvider instanceof FileResource || fileProvider == null) {
            return (FileResource)fileProvider;
        }
        FileResource result = new FileResource(fileProvider.getFile());
        result.setProject(Project.getProject(fileProvider));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int binaryCompare(Resource r1, Resource r2) throws IOException {
        block5: {
            in1 = null;
            in2 = null;
            try {
                in1 = new BufferedInputStream(r1.getInputStream());
                in2 = new BufferedInputStream(r2.getInputStream());
                b1 = in1.read();
lbl7:
                // 2 sources

                while (b1 != -1) {
                    b2 = in2.read();
                    if (b1 != b2) {
                        var6_6 = b1 > b2 ? 1 : -1;
                        break block5;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl24
            }
            catch (Throwable var7_7) {
                FileUtils.close(in1);
                FileUtils.close(in2);
                throw var7_7;
            }
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return var6_6;
lbl-1000:
        // 1 sources

        {
            b1 = in1.read();
            ** GOTO lbl7
lbl24:
            // 1 sources

            var4_4 = in2.read() == -1 ? 0 : -1;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int textCompare(Resource r1, Resource r2) throws IOException {
        int n;
        BufferedReader in2;
        BufferedReader in1;
        block5: {
            int n2;
            in1 = null;
            in2 = null;
            try {
                in1 = new BufferedReader(new InputStreamReader(r1.getInputStream()));
                in2 = new BufferedReader(new InputStreamReader(r2.getInputStream()));
                String expected = in1.readLine();
                while (expected != null) {
                    String actual = in2.readLine();
                    if (!expected.equals(actual)) {
                        n = expected.compareTo(actual);
                        break block5;
                    }
                    expected = in1.readLine();
                }
                n2 = in2.readLine() == null ? 0 : -1;
            }
            catch (Throwable throwable) {
                FileUtils.close(in1);
                FileUtils.close(in2);
                throw throwable;
            }
            FileUtils.close(in1);
            FileUtils.close(in2);
            return n2;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return n;
    }

    private static void logFuture(ProjectComponent logTo, ResourceCollection rc, long granularity) {
        long now = System.currentTimeMillis() + granularity;
        Date sel = new Date();
        sel.setMillis(now);
        sel.setWhen(TimeComparison.AFTER);
        Restrict future = new Restrict();
        future.add(sel);
        future.add(rc);
        Iterator iter = future.iterator();
        while (iter.hasNext()) {
            logTo.log("Warning: " + ((Resource)iter.next()).getName() + " modified in the future.", 1);
        }
    }

    private static OutputStream getOutputStream(Resource resource, boolean append, Project project) throws IOException {
        if (append) {
            Appendable a = (Appendable)resource.as(class$org$apache$tools$ant$types$resources$Appendable == null ? (class$org$apache$tools$ant$types$resources$Appendable = ResourceUtils.class$("org.apache.tools.ant.types.resources.Appendable")) : class$org$apache$tools$ant$types$resources$Appendable);
            if (a != null) {
                return a.getAppendOutputStream();
            }
            project.log("Appendable OutputStream not available for non-appendable resource " + resource + "; using plain OutputStream", 3);
        }
        return resource.getOutputStream();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ResourceSelectorProvider {
        public ResourceSelector getTargetSelectorForSource(Resource var1);
    }
}

