/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.internal.nebula.grid;

import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GridPasteKeyListener
implements KeyListener {
    private final Clipboard clipboard;

    public GridPasteKeyListener(Display display) {
        this.clipboard = new Clipboard(display);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 118) {
            Grid grid = (Grid)e.widget;
            Object contents = this.clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (contents instanceof String) {
                this.pasteSelection(grid, (String)contents);
            }
        }
    }

    public void pasteSelection(Grid grid, String contents) {
        if (grid.getCellSelection().length == 0) {
            return;
        }
        Point startItem = grid.getCellSelection()[0];
        int startColumn = startItem.x;
        int startRow = startItem.y;
        int relativeRow = -1;
        int relativeColumn = -1;
        StringTokenizer rowTokenizer = new StringTokenizer(contents, "\n", true);
        while (rowTokenizer.hasMoreTokens()) {
            ++relativeRow;
            String columnString = rowTokenizer.nextToken();
            boolean rowUpdate = false;
            while (rowTokenizer.hasMoreTokens() && columnString.equals("\n")) {
                ++relativeRow;
                columnString = rowTokenizer.nextToken();
                rowUpdate = true;
            }
            if (rowUpdate) {
                --relativeRow;
            }
            StringTokenizer columnTokenizer = new StringTokenizer(columnString, "\t", true);
            relativeColumn = -1;
            while (columnTokenizer.hasMoreTokens()) {
                int insertionIndex;
                ++relativeColumn;
                String text = columnTokenizer.nextToken();
                while (columnTokenizer.hasMoreTokens() && text.equals("\t")) {
                    ++relativeColumn;
                    text = columnTokenizer.nextToken();
                }
                if (text.equals("\t") || (insertionIndex = startRow + relativeRow) >= grid.getItemCount()) continue;
                grid.getItem(startRow + relativeRow).setText(startColumn + relativeColumn, text);
            }
        }
    }
}

