/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.common.dnd;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.ui.common.dnd.ECPDropAdapter;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;

public class ModelExplorerDropAdapter
extends ECPDropAdapter {
    public ModelExplorerDropAdapter(Viewer viewer) {
        super(null, viewer);
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.domain == null) {
            return;
        }
        super.dragEnter(event);
    }

    public void dragOver(DropTargetEvent event) {
        Object target = this.extractDropTarget(event.item);
        if (target == null) {
            return;
        }
        this.source = this.getDragSource(event);
        Object sourceObject = null;
        if (this.source == null) {
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                sourceObject = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            }
        } else {
            sourceObject = this.source.iterator().next();
        }
        EditingDomain sourceProjectDomain = this.getProjectDomain(sourceObject);
        EditingDomain targetProjectDomain = this.getProjectDomain(target);
        EditingDomain newDomain = null;
        newDomain = target instanceof ECPProject ? ((ECPProject)target).getEditingDomain() : AdapterFactoryEditingDomain.getEditingDomainFor((Object)target);
        if (this.domain == null || newDomain != null && sourceProjectDomain == targetProjectDomain) {
            this.domain = newDomain;
        }
        if (target instanceof ECPProject) {
            ECPProject project = (ECPProject)target;
            if (sourceObject instanceof ECPProject) {
                event.detail = 1;
                event.feedback = 14;
            } else if (project.getContents().contains(sourceObject)) {
                event.detail = this.originalOperation != 1 ? 0 : 1;
            } else {
                event.feedback = 1 | this.getAutoFeedback();
                event.detail = sourceProjectDomain == targetProjectDomain ? 2 : 1;
            }
        } else if (sourceProjectDomain != targetProjectDomain) {
            event.detail = 0;
        } else {
            super.dragOver(event);
        }
    }

    public void drop(final DropTargetEvent event) {
        Object target = this.extractDropTarget(event.item);
        this.source = this.getDragSource(event);
        final Object sourceObject = this.source.iterator().next();
        if (target instanceof ECPProject) {
            final ECPProject project = (ECPProject)target;
            if (sourceObject instanceof EObject) {
                project.getEditingDomain().getCommandStack().execute((Command)new ChangeCommand((Notifier)((EObject)sourceObject)){

                    protected void doExecute() {
                        if (event.detail == 2) {
                            project.getContents().add(sourceObject);
                        } else if (event.detail == 1) {
                            project.getContents().add((Object)EcoreUtil.copy((EObject)((EObject)sourceObject)));
                        }
                    }
                });
            } else if (sourceObject instanceof ECPProject) {
                ECPProject oldProject = (ECPProject)sourceObject;
                ECPUtil.getECPProjectManager().createProject(oldProject, String.valueOf(oldProject.getName()) + "(Copy)");
            }
        } else if (event.detail != 0) {
            super.drop(event);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        Object target = this.extractDropTarget(event.item);
        if (target instanceof ECPProject) {
            event.feedback = 1 | this.getAutoFeedback();
        } else {
            super.dropAccept(event);
        }
    }
}

