/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.layout;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.emf.ecp.view.model.common.AbstractGridCell;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.graphics.Point;

public final class GridDescriptionFactory {
    public static final GridDescriptionFactory INSTANCE = new GridDescriptionFactory();

    private GridDescriptionFactory() {
    }

    public SWTGridDescription createEmptyGridDescription() {
        return new SWTGridDescription();
    }

    public SWTGridDescription createSimpleGrid(int rows, int columns, AbstractSWTRenderer<? extends VElement> renderer) {
        ArrayList<SWTGridCell> gridCells = new ArrayList<SWTGridCell>(rows * columns);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                gridCells.add(new SWTGridCell(row, column, renderer));
                ++column;
            }
            ++row;
        }
        return new SWTGridDescription(rows, columns, gridCells);
    }

    public SWTGridDescription createCompactGrid(boolean label, boolean validation, AbstractSWTRenderer<? extends VElement> renderer) {
        LinkedList<SWTGridCell> gridCells = new LinkedList<SWTGridCell>();
        if (label) {
            gridCells.add(this.createDefaultCompactLabelCell(0, renderer));
        }
        if (validation) {
            int validationColumn = label ? 1 : 0;
            gridCells.add(this.createDefaultCompactValidationCell(validationColumn, renderer));
        }
        int mainColumn = (label ? 1 : 0) + (validation ? 1 : 0);
        gridCells.add(this.createDefaultCompactMainCell(mainColumn, renderer));
        return new SWTGridDescription(1, mainColumn + 1, gridCells);
    }

    private SWTGridCell createDefaultCompactLabelCell(int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell labelCell = new SWTGridCell(0, column, renderer);
        labelCell.setHorizontalGrab(false);
        labelCell.setVerticalGrab(false);
        labelCell.setHorizontalFill(false);
        labelCell.setHorizontalAlignment(AbstractGridCell.Alignment.BEGINNING);
        labelCell.setVerticalFill(false);
        labelCell.setVerticalAlignment(AbstractGridCell.Alignment.BEGINNING);
        labelCell.setPreferredSize(null);
        return labelCell;
    }

    private SWTGridCell createDefaultCompactValidationCell(int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell validationCell = new SWTGridCell(0, column, renderer);
        validationCell.setHorizontalGrab(false);
        validationCell.setVerticalGrab(false);
        validationCell.setHorizontalFill(false);
        validationCell.setHorizontalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setVerticalFill(false);
        validationCell.setVerticalAlignment(AbstractGridCell.Alignment.BEGINNING);
        validationCell.setPreferredSize(new Point(16, 17));
        return validationCell;
    }

    private SWTGridCell createDefaultCompactMainCell(int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell mainCell = new SWTGridCell(0, column, renderer);
        mainCell.setHorizontalGrab(true);
        mainCell.setVerticalGrab(true);
        mainCell.setHorizontalFill(true);
        mainCell.setHorizontalAlignment(AbstractGridCell.Alignment.CENTER);
        mainCell.setVerticalFill(true);
        mainCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        mainCell.setPreferredSize(null);
        return mainCell;
    }
}

