/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.provider.internal;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.changebroker.spi.AbstractNotificationProvider;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProvidersChangedObserver;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.ProviderChangeListener;

public class ECPNotificationProvider
extends AbstractNotificationProvider
implements ProviderChangeListener {
    public void bindManager(ECPProjectManager manager) {
        manager.getProjects();
        ECPUtil.getECPObserverBus().register((ECPObserver)new ECPProvidersChangedObserver(){

            public void providersChanged(Collection<ECPProvider> oldProviders, Collection<ECPProvider> newProviders) {
                for (ECPProvider ecpProvider : newProviders) {
                    ECPNotificationProvider.this.addObserver((InternalProvider)ecpProvider);
                }
            }
        });
    }

    public void bindProviderRegistry(ECPProviderRegistry registry) {
        for (ECPProvider ecpProvider : registry.getProviders()) {
            this.addObserver((InternalProvider)ecpProvider);
        }
    }

    private void addObserver(InternalProvider ecpProvider) {
        ecpProvider.registerChangeListener((ProviderChangeListener)this);
    }

    public void notify(Notification notification) {
        this.notifyAllReceivers(notification);
    }

    public void postDelete(EObject objectToBeDeleted) {
        this.notifyPostDelete(objectToBeDeleted);
    }

    public void preDelete(EObject objectToBeDeleted) {
        this.notifyPreDelete(objectToBeDeleted);
    }

    public boolean canDelete(EObject objectToBeDeleted) {
        return this.notifyCanDelete(objectToBeDeleted);
    }
}

