/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.common.internal.validation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.common.internal.validation.DiagnosticHelper;
import org.eclipse.emfforms.common.spi.validation.ValidationResultListener;
import org.eclipse.emfforms.common.spi.validation.ValidationService;
import org.eclipse.emfforms.common.spi.validation.Validator;
import org.eclipse.emfforms.common.spi.validation.exception.ValidationCanceledException;
import org.eclipse.emfforms.common.spi.validation.filter.DiagnosticFilter;
import org.eclipse.emfforms.common.spi.validation.filter.ObjectFilter;
import org.eclipse.emfforms.common.spi.validation.filter.SubTreeFilter;
import org.eclipse.emfforms.common.spi.validation.filter.ValidationFilter;

public class ValidationServiceImpl
implements ValidationService {
    private final Set<Validator> validators = new LinkedHashSet<Validator>();
    private final Set<ObjectFilter> objectFilter = new LinkedHashSet<ObjectFilter>();
    private final Set<SubTreeFilter> subTreeFilters = new LinkedHashSet<SubTreeFilter>();
    private final Set<DiagnosticFilter> diagnosticFilters = new LinkedHashSet<DiagnosticFilter>();
    private final Set<ValidationResultListener> validationResultListeners = new LinkedHashSet<ValidationResultListener>();
    private EValidator.SubstitutionLabelProvider substitutionLabelProvider;
    private boolean validationRunning;
    private boolean cancelationRequested;
    private final Diagnostician diagnostician = new DiagnosticianImpl();
    private Map<Object, Object> validationContext;

    private boolean isFiltered(EObject object) {
        if (this.objectFilter.isEmpty()) {
            return false;
        }
        for (ObjectFilter filter : this.objectFilter) {
            if (!filter.skipValidation(object)) continue;
            return true;
        }
        return false;
    }

    private boolean isSkipSubtree(EObject object, Optional<Diagnostic> diagnostic) {
        if (this.subTreeFilters.isEmpty()) {
            return false;
        }
        for (SubTreeFilter filter : this.subTreeFilters) {
            if (!filter.skipSubtree(object, diagnostic)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnored(EObject object, Diagnostic diagnostic) {
        if (this.diagnosticFilters.isEmpty()) {
            return false;
        }
        for (DiagnosticFilter filter : this.diagnosticFilters) {
            if (!filter.ignoreDiagnostic(object, diagnostic)) continue;
            return true;
        }
        return false;
    }

    private Diagnostic doValidate(EObject eObject) {
        Diagnostic diagnostic = null;
        try {
            Diagnostic diagnostic2 = diagnostic = this.getDiagnosticForEObject(eObject);
            return diagnostic2;
        }
        finally {
            this.invokeValidationResultListeners(eObject, diagnostic, false);
        }
    }

    @Override
    public Diagnostic validate(EObject eObject) {
        if (this.isFiltered(eObject)) {
            return null;
        }
        return this.doValidate(eObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Diagnostic> validate(Iterator<EObject> eObjectsIterator) throws ValidationCanceledException {
        LinkedHashSet<Diagnostic> diagnostics = new LinkedHashSet<Diagnostic>();
        if (this.validationRunning) {
            return diagnostics;
        }
        this.validationRunning = true;
        this.validationContext = new LinkedHashMap<Object, Object>();
        try {
            boolean isTreeIterator = eObjectsIterator instanceof TreeIterator;
            while (!this.cancelationRequested && eObjectsIterator.hasNext()) {
                EObject eObject = eObjectsIterator.next();
                Diagnostic diagnostic = null;
                boolean isSubtreePruned = false;
                if (isTreeIterator && this.isSkipSubtree(eObject, (Optional<Diagnostic>)Optional.ofNullable(diagnostic))) {
                    ((TreeIterator)eObjectsIterator).prune();
                    isSubtreePruned = true;
                }
                if (this.isFiltered(eObject)) continue;
                diagnostic = this.doValidate(eObject);
                if (isTreeIterator && !isSubtreePruned && this.isSkipSubtree(eObject, (Optional<Diagnostic>)Optional.of((Object)diagnostic))) {
                    ((TreeIterator)eObjectsIterator).prune();
                }
                if (this.isIgnored(eObject, diagnostic)) continue;
                diagnostics.add(diagnostic);
                this.invokeValidationResultListeners(eObject, diagnostic, true);
            }
        }
        finally {
            this.validationRunning = false;
            this.validationContext = null;
        }
        if (this.cancelationRequested) {
            throw new ValidationCanceledException();
        }
        return diagnostics;
    }

    private void invokeValidationResultListeners(EObject eObject, Diagnostic diagnostic, boolean passed) {
        if (this.validationResultListeners.isEmpty()) {
            return;
        }
        for (ValidationResultListener listener : this.validationResultListeners) {
            if (passed) {
                listener.afterValidate(eObject, diagnostic);
                continue;
            }
            listener.onValidate(eObject, diagnostic);
        }
    }

    protected EValidator getEValidatorForEObject(EObject eObject) {
        if (EValidator.Registry.INSTANCE.getEValidator(eObject.eClass().getEPackage()) == null) {
            return new EObjectValidator();
        }
        return this.diagnostician;
    }

    protected Diagnostic getDiagnosticForEObject(EObject object) {
        EValidator eValidator = this.getEValidatorForEObject(object);
        BasicDiagnostic diagnostic = this.diagnostician.createDefaultDiagnostic(object);
        Map<Object, Object> context = this.getValidationContext(eValidator);
        eValidator.validate(object, (DiagnosticChain)diagnostic, context);
        LinkedHashMap<EStructuralFeature, DiagnosticChain> diagnosticMap = new LinkedHashMap<EStructuralFeature, DiagnosticChain>();
        for (Diagnostic child : diagnostic.getChildren()) {
            if (!DiagnosticChain.class.isInstance(child) || !DiagnosticHelper.checkDiagnosticData(child)) continue;
            diagnosticMap.put(DiagnosticHelper.getEStructuralFeature(child.getData()), (DiagnosticChain)child);
        }
        for (Validator validator : this.validators) {
            List<Diagnostic> additionValidation = validator.validate(object);
            if (additionValidation == null) continue;
            for (Diagnostic additionDiagnostic : additionValidation) {
                if (diagnosticMap.containsKey(DiagnosticHelper.getEStructuralFeature(additionDiagnostic.getData()))) {
                    ((DiagnosticChain)diagnosticMap.get(DiagnosticHelper.getEStructuralFeature(additionDiagnostic.getData()))).add(additionDiagnostic);
                    continue;
                }
                if (additionDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(additionDiagnostic);
            }
        }
        return diagnostic;
    }

    protected Map<Object, Object> getValidationContext(EValidator eValidator) {
        Map<Object, Object> result = this.validationContext == null ? new LinkedHashMap() : this.validationContext;
        result.put(EValidator.class, eValidator);
        if (this.substitutionLabelProvider != null) {
            result.put(EValidator.SubstitutionLabelProvider.class, this.substitutionLabelProvider);
        }
        return result;
    }

    @Override
    public void addValidator(Validator validator) {
        this.validators.add(validator);
    }

    @Override
    public void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }

    public void registerValidationFilter(ValidationFilter filter) {
        if (filter instanceof ObjectFilter) {
            this.objectFilter.add((ObjectFilter)filter);
        }
        if (filter instanceof SubTreeFilter) {
            this.subTreeFilters.add((SubTreeFilter)filter);
        }
        if (filter instanceof DiagnosticFilter) {
            this.diagnosticFilters.add((DiagnosticFilter)filter);
        }
    }

    public void unregisterValidationFilter(ValidationFilter filter) {
        this.objectFilter.remove(filter);
        this.subTreeFilters.remove(filter);
        this.diagnosticFilters.remove(filter);
    }

    @Override
    public void registerValidationResultListener(ValidationResultListener listener) {
        this.validationResultListeners.add(listener);
    }

    @Override
    public void unregisterValidationResultListener(ValidationResultListener listener) {
        this.validationResultListeners.remove(listener);
    }

    @Override
    public void setSubstitutionLabelProvider(EValidator.SubstitutionLabelProvider substitutionLabelProvider) {
        this.substitutionLabelProvider = substitutionLabelProvider;
    }

    @Override
    public boolean isBusy() {
        return this.validationRunning;
    }

    @Override
    public void cancel() {
        this.cancelationRequested = true;
    }

    private final class DiagnosticianImpl
    extends Diagnostician {
        DiagnosticianImpl() {
            super(EValidator.Registry.INSTANCE);
        }

        public String getObjectLabel(EObject eObject) {
            return ValidationServiceImpl.this.substitutionLabelProvider != null ? ValidationServiceImpl.this.substitutionLabelProvider.getObjectLabel(eObject) : super.getObjectLabel(eObject);
        }

        public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
            return ValidationServiceImpl.this.substitutionLabelProvider != null ? ValidationServiceImpl.this.substitutionLabelProvider.getFeatureLabel(eStructuralFeature) : super.getFeatureLabel(eStructuralFeature);
        }

        public String getValueLabel(EDataType eDataType, Object value) {
            return ValidationServiceImpl.this.substitutionLabelProvider != null ? ValidationServiceImpl.this.substitutionLabelProvider.getValueLabel(eDataType, value) : super.getValueLabel(eDataType, value);
        }

        public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            Object eValidator;
            EClass eType = eClass;
            while ((eValidator = this.eValidatorRegistry.get((Object)eType.eContainer())) == null) {
                EList eSuperTypes = eType.getESuperTypes();
                if (eSuperTypes.isEmpty()) {
                    eValidator = this.eValidatorRegistry.get(null);
                    break;
                }
                eType = (EClass)eSuperTypes.get(0);
            }
            return this.doValidate((EValidator)eValidator, eClass, eObject, diagnostics, context);
        }
    }
}

