/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.table.internal.validation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.EMFFormsViewService;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextListener;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

public class TableValidationInitiator
implements GlobalViewModelService,
EMFFormsContextListener {
    private final Map<UniqueSetting, TableContextMapping> mapping = new LinkedHashMap<UniqueSetting, TableContextMapping>();
    private ViewModelContext context;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        context.registerDomainChangeListener(new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch() || TableValidationInitiator.this.mapping.isEmpty()) {
                    return;
                }
                TableContextMapping tableContextMapping = (TableContextMapping)TableValidationInitiator.this.mapping.get(UniqueSetting.createSetting((EObject)notification.getNotifier(), (EStructuralFeature)notification.getStructuralFeature()));
                if (tableContextMapping == null) {
                    return;
                }
                TableValidationInitiator.this.checkAdditions(notification, tableContextMapping);
                TableValidationInitiator.this.checkRemovals(notification, tableContextMapping);
            }
        });
        this.checkForTables(context);
        context.registerEMFFormsContextListener((EMFFormsContextListener)this);
    }

    private void checkForTables(ViewModelContext context) {
        VElement viewRoot = context.getViewModel();
        TreeIterator eAllContents = viewRoot.eAllContents();
        while (eAllContents.hasNext()) {
            IObservableValue observableValue;
            VTableControl tableControl;
            EObject eObject = (EObject)eAllContents.next();
            if (!VTableControl.class.isInstance(eObject) || !this.isCorrectContainer(tableControl = (VTableControl)VTableControl.class.cast(eObject), (EObject)viewRoot) || tableControl.getDetailEditing() != DetailEditing.WITH_PANEL) continue;
            VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)tableControl.getDomainModelReference();
            try {
                observableValue = tableDomainModelReference.getDomainModelReference() != null ? ((EMFFormsDatabinding)context.getService(EMFFormsDatabinding.class)).getObservableValue(tableDomainModelReference.getDomainModelReference(), context.getDomainModel()) : ((EMFFormsDatabinding)context.getService(EMFFormsDatabinding.class)).getObservableValue((VDomainModelReference)tableDomainModelReference, context.getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                ((ReportService)context.getService(ReportService.class)).report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                continue;
            }
            IObserving observing = (IObserving)observableValue;
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject observed = (EObject)observing.getObserved();
            observableValue.dispose();
            this.mapping.put(UniqueSetting.createSetting((EObject)observed, (EStructuralFeature)structuralFeature), new TableContextMapping(tableControl, context));
            EList tableContents = (EList)observed.eGet(structuralFeature, true);
            for (EObject tableEObject : tableContents) {
                try {
                    VView detailView = this.getView(tableControl, tableEObject);
                    ViewModelContext childContext = context.getChildContext(tableEObject, (VElement)tableControl, detailView, new ViewModelService[0]);
                    childContext.addContextUser((Object)this);
                }
                catch (DatabindingFailedException ex) {
                    ((ReportService)context.getService(ReportService.class)).report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        }
    }

    private boolean isCorrectContainer(VTableControl tableControl, EObject root) {
        EObject current = tableControl.eContainer();
        while (!VView.class.isInstance(current) && current != root) {
            current = current.eContainer();
        }
        return current == root;
    }

    private VView getView(VTableControl tableControl, EObject newEntry) throws DatabindingFailedException {
        VView detailView = tableControl.getDetailView();
        if (detailView == null) {
            VElement viewModel = this.context.getViewModel();
            VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
            detailView = ((EMFFormsViewService)this.context.getService(EMFFormsViewService.class)).getView(newEntry, properties);
        }
        if (detailView == null) {
            throw new IllegalStateException(String.format("No View Model could be created for %1$s. Please check your ViewModel Provider.", newEntry.eClass().getName()));
        }
        return detailView;
    }

    public void dispose() {
        this.context.unregisterEMFFormsContextListener((EMFFormsContextListener)this);
    }

    public int getPriority() {
        return 1;
    }

    public void childViewModelContextAdded(ViewModelContext childContext) {
        this.checkForTables(childContext);
        childContext.registerEMFFormsContextListener((EMFFormsContextListener)this);
    }

    public void childContextAdded(VElement parentElement, EMFFormsViewContext childContext) {
        if (ViewModelContext.class.isInstance(childContext)) {
            this.checkForTables((ViewModelContext)ViewModelContext.class.cast(childContext));
            childContext.registerEMFFormsContextListener((EMFFormsContextListener)this);
        }
    }

    public void childContextDisposed(EMFFormsViewContext childContext) {
    }

    public void contextInitialised() {
    }

    public void contextDispose() {
    }

    private void checkAdditions(ModelChangeNotification notification, TableContextMapping tableContextMapping) {
        for (EObject newValue : notification.getNewEObjects()) {
            try {
                ViewModelContext vmc = tableContextMapping.context.getChildContext(newValue, (VElement)tableContextMapping.control, this.getView(tableContextMapping.control, newValue), new ViewModelService[0]);
                vmc.addContextUser((Object)this);
            }
            catch (DatabindingFailedException ex) {
                ((ReportService)this.context.getService(ReportService.class)).report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }
    }

    private void checkRemovals(ModelChangeNotification notification, TableContextMapping tableContextMapping) {
        for (EObject oldValue : notification.getOldEObjects()) {
            try {
                ViewModelContext vmc = tableContextMapping.context.getChildContext(oldValue, (VElement)tableContextMapping.control, this.getView(tableContextMapping.control, oldValue), new ViewModelService[0]);
                vmc.removeContextUser((Object)this);
            }
            catch (DatabindingFailedException ex) {
                ((ReportService)this.context.getService(ReportService.class)).report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }
    }

    private static class TableContextMapping {
        private final VTableControl control;
        private final ViewModelContext context;

        TableContextMapping(VTableControl control, ViewModelContext context) {
            this.control = control;
            this.context = context;
        }
    }
}

