/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.treemasterdetail.decorator.validation.ecp;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ECPValidationServiceLabelDecorator
implements ILabelDecorator {
    private final DiagnosticCache cache;
    private final TreeViewer viewer;

    public ECPValidationServiceLabelDecorator(TreeViewer viewer, Notifier input, DiagnosticCache cache) {
        this.viewer = viewer;
        this.cache = cache;
        cache.registerValidationListener(new DiagnosticCache.ValidationListener(){

            public void revalidationOccurred(Collection<EObject> object, boolean potentialStructuralChange) {
                if (potentialStructuralChange) {
                    for (EObject o : object) {
                        ECPValidationServiceLabelDecorator.this.refreshViewer(o);
                    }
                } else {
                    for (EObject o : object) {
                        ECPValidationServiceLabelDecorator.this.updateViewer(o);
                    }
                }
            }
        });
        viewer.refresh();
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return image;
        }
        if (!EObject.class.isInstance(element) && !Resource.class.isInstance(element)) {
            return image;
        }
        Diagnostic diagnostic = (Diagnostic)this.cache.getCachedValue(element);
        int severity = diagnostic.getSeverity();
        ImageDescriptor validationOverlayDescriptor = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(severity);
        if (validationOverlayDescriptor == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        Point size = new Point(bounds.width, bounds.height);
        DecorationOverlayIcon icon = new DecorationOverlayIcon(image, new ImageDescriptor[]{validationOverlayDescriptor}, size);
        return icon.createImage();
    }

    protected void refreshViewer(EObject element) {
        this.viewer.refresh((Object)element, true);
    }

    protected void updateViewer(EObject element) {
        this.viewer.update((Object)element, null);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.cache.dispose();
    }
}

