/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.DateUtil;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class XMLDateControlSWTRenderer
extends TextControlSWTRenderer {
    private final EMFFormsLocaleProvider localeProvider;
    private final EMFFormsLocalizationService localizationService;
    private final ImageRegistryService imageRegistryService;
    private static final DateFormat CHECK_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    private static final Pattern CHECK_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private Shell dialog;
    private EMFFormsLocaleChangeListener emfFormsLocaleChangeListener;
    private Text text;

    @Inject
    public XMLDateControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport, EMFFormsLocalizationService localizationService, EMFFormsLocaleProvider localeProvider, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        this.localizationService = localizationService;
        this.localeProvider = localeProvider;
        this.imageRegistryService = imageRegistryService;
    }

    @Override
    protected Object convert(Text text, EDataType attributeType, String value) throws DatabindingFailedException {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        DateTargetToModelUpdateStrategy converter = new DateTargetToModelUpdateStrategy(eStructuralFeature, text);
        return converter.convert(value);
    }

    @Override
    protected Control createSWTControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        Control control = super.createSWTControl(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo(control);
        Button bDate = new Button(main, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bDate);
        bDate.setImage(this.imageRegistryService.getImage(FrameworkUtil.getBundle(XMLDateControlSWTRenderer.class), "icons/date.png"));
        bDate.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_xmldate");
        this.text = (Text)((Composite)Composite.class.cast(control)).getChildren()[0];
        bDate.addSelectionListener((SelectionListener)new SelectionAdapterExtension(this.text, bDate));
        return main;
    }

    @Override
    protected String getTextMessage() {
        return ((SimpleDateFormat)this.setupFormat()).toPattern();
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_xmldate";
    }

    @Override
    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        final Text text = (Text)((Composite)Composite.class.cast(((Composite)Composite.class.cast(control)).getChildren()[0])).getChildren()[0];
        ISWTObservableValue value = WidgetProperties.text((int)16).observe((Widget)text);
        UpdateValueStrategy targetToModelUpdateStrategy = this.withPreSetValidation((UpdateValueStrategy)new DateTargetToModelUpdateStrategy(structuralFeature, text));
        DateModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new DateModelToTargetUpdateStrategy(false);
        final Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(), this.getDataBindingContext(), null, (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(true));
        this.emfFormsLocaleChangeListener = new EMFFormsLocaleChangeListener(){

            public void notifyLocaleChange() {
                text.setMessage(XMLDateControlSWTRenderer.this.getTextMessage());
                binding.updateModelToTarget();
            }
        };
        this.localeProvider.addEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
        return new Binding[]{binding, tooltipBinding};
    }

    protected DateFormat setupFormat() {
        DateFormat df = DateFormat.getDateInstance(2, this.localeProvider.getLocale());
        df.setLenient(false);
        return df;
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        super.setValidationColor(this.getControlCompositeFromControl(control), validationColor);
    }

    @Override
    protected void setValidationForegroundColor(Control control, Color validationColor) {
        super.setValidationForegroundColor(this.getControlCompositeFromControl(control), validationColor);
    }

    @Override
    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || this.hasLeftLabelAlignment() && gridCell.getColumn() == 2) {
            if (this.isUnsetButtonLeftOfControlComposite()) {
                super.setControlEnabled(gridCell, control, enabled);
                ((Button)((Composite)control).getChildren()[0]).setVisible(enabled);
            } else {
                super.setControlEnabled(gridCell, control, enabled);
                ((Button)((Composite)control).getChildren()[1]).setVisible(enabled);
            }
        } else {
            super.setControlEnabled(gridCell, control, enabled);
        }
    }

    @Override
    protected String getUnsetText() {
        return this.localizationService.getString(((Object)((Object)this)).getClass(), "XmlDateControlText_NoDateSetClickToSetDate");
    }

    @Override
    protected void dispose() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
        }
        this.localeProvider.removeEMFFormsLocaleChangeListener(this.emfFormsLocaleChangeListener);
        super.dispose();
    }

    private class DateModelToTargetUpdateStrategy
    extends TextControlSWTRenderer.ModelToTargetUpdateStrategy {
        private final boolean toDate;

        DateModelToTargetUpdateStrategy(boolean tooltip, boolean toDate) {
            super(XMLDateControlSWTRenderer.this, tooltip);
            this.toDate = toDate;
        }

        DateModelToTargetUpdateStrategy(boolean tooltip) {
            this(tooltip, false);
        }

        @Override
        public Object convertValue(Object value) {
            DateFormat format = XMLDateControlSWTRenderer.this.setupFormat();
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)value;
            if (gregorianCalendar == null) {
                return null;
            }
            Date date = gregorianCalendar.toGregorianCalendar().getTime();
            if (this.toDate) {
                return date;
            }
            return format.format(date);
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            if (value == null && this.toDate) {
                return Status.OK_STATUS;
            }
            if (value == null && !this.toDate) {
                value = "";
            }
            return super.doSet(observableValue, value);
        }
    }

    private class DateTargetToModelUpdateStrategy
    extends TextControlSWTRenderer.TargetToModelUpdateStrategy {
        private final EStructuralFeature eStructuralFeature;
        private final Text text;
        private final boolean isDate;

        DateTargetToModelUpdateStrategy(EStructuralFeature eStructuralFeature, Text text) {
            super(XMLDateControlSWTRenderer.this, eStructuralFeature.isUnsettable());
            this.eStructuralFeature = eStructuralFeature;
            this.text = text;
            EClassifier eType = eStructuralFeature.getEType();
            if (eType == null) {
                this.isDate = true;
                return;
            }
            EAnnotation eAnnotation = eType.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            if (eAnnotation == null) {
                this.isDate = true;
                return;
            }
            EMap typeDetails = eAnnotation.getDetails();
            this.isDate = typeDetails.containsKey((Object)"name") ? "date".equals(typeDetails.get((Object)"name")) : (typeDetails.containsKey((Object)"baseType") ? ((String)typeDetails.get((Object)"baseType")).endsWith("date") : true);
        }

        @Override
        protected Object convertValue(Object value) {
            try {
                Date date = null;
                if (String.class.isInstance(value)) {
                    date = XMLDateControlSWTRenderer.this.setupFormat().parse((String)value);
                } else if (Date.class.isInstance(value)) {
                    date = (Date)value;
                } else if (value == null) {
                    return value;
                }
                String xmlFormat = CHECK_FORMAT.format(date);
                if (!CHECK_PATTERN.matcher(xmlFormat).matches()) {
                    return this.revertToOldValue(value);
                }
                String formatedDate = XMLDateControlSWTRenderer.this.setupFormat().format(date);
                this.text.setText(formatedDate);
                Calendar targetCal = Calendar.getInstance();
                targetCal.setTime(date);
                if (this.isDate) {
                    return DateUtil.convertOnlyDateToXMLGregorianCalendar((Calendar)targetCal);
                }
                return DateUtil.convertCalendarToXMLGregorianCalendar((Calendar)targetCal);
            }
            catch (ParseException ex) {
                return this.revertToOldValue(value);
            }
        }

        private Object revertToOldValue(Object value) {
            Object result;
            if (this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            try {
                result = XMLDateControlSWTRenderer.this.getModelValue().getValue();
            }
            catch (DatabindingFailedException ex) {
                XMLDateControlSWTRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
                return null;
            }
            MessageDialog messageDialog = new MessageDialog(this.text.getShell(), LocalizationServiceHelper.getString(XMLDateControlSWTRenderer.class, (String)"XmlDateControlText_InvalidNumber"), null, LocalizationServiceHelper.getString(XMLDateControlSWTRenderer.class, (String)"XmlDateControlText_NumberInvalidValueWillBeUnset"), 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            XMLDateControlSWTRenderer.this.getDataBindingContext().updateTargets();
            if (this.eStructuralFeature.isUnsettable() && result == null) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }

    private final class SelectionAdapterExtension
    extends SelectionAdapter {
        private final Control button;
        private final Text text;

        private SelectionAdapterExtension(Text text, Button button) {
            this.text = text;
            this.button = button;
        }

        public void widgetSelected(SelectionEvent e) {
            EStructuralFeature eStructuralFeature;
            IObservableValue modelValue;
            if (XMLDateControlSWTRenderer.this.dialog != null && !XMLDateControlSWTRenderer.this.dialog.isDisposed()) {
                XMLDateControlSWTRenderer.this.dialog.dispose();
                return;
            }
            try {
                modelValue = XMLDateControlSWTRenderer.this.getModelValue();
                eStructuralFeature = (EStructuralFeature)modelValue.getValueType();
            }
            catch (DatabindingFailedException ex) {
                XMLDateControlSWTRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
                return;
            }
            XMLDateControlSWTRenderer.this.dialog = new Shell(this.button.getShell(), 0);
            XMLDateControlSWTRenderer.this.dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)XMLDateControlSWTRenderer.this.dialog, 3072);
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)modelValue.getValue();
            Calendar cal = Calendar.getInstance(XMLDateControlSWTRenderer.this.localeProvider.getLocale());
            if (gregorianCalendar != null) {
                cal.setTime(gregorianCalendar.toGregorianCalendar().getTime());
            }
            calendar.setDate(cal.get(1), cal.get(2), cal.get(5));
            ISWTObservableValue dateObserver = WidgetProperties.selection().observe((Widget)calendar);
            final Binding binding = XMLDateControlSWTRenderer.this.getDataBindingContext().bindValue((IObservableValue)dateObserver, modelValue, (UpdateValueStrategy)new DateTargetToModelUpdateStrategy(eStructuralFeature, this.text), (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(false, true));
            binding.updateModelToTarget();
            Button okButton = new Button((Composite)XMLDateControlSWTRenderer.this.dialog, 8);
            okButton.setText(JFaceResources.getString((String)"ok"));
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)okButton);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    XMLDateControlSWTRenderer.this.dialog.close();
                }
            });
            XMLDateControlSWTRenderer.this.dialog.pack();
            XMLDateControlSWTRenderer.this.dialog.layout();
            Point dialogSize = XMLDateControlSWTRenderer.this.dialog.getSize();
            Rectangle displayBounds = XMLDateControlSWTRenderer.this.dialog.getDisplay().getBounds();
            Point buttonLocation = this.button.toDisplay(this.button.getSize().x, this.button.getSize().y);
            int dialogX = buttonLocation.x - dialogSize.x;
            int dialogY = buttonLocation.y;
            if (dialogY + dialogSize.y > displayBounds.height) {
                dialogY = dialogY - this.button.getSize().y - dialogSize.y;
            }
            if (dialogX + dialogSize.x > displayBounds.width) {
                dialogX -= dialogSize.x;
            } else if (dialogX - dialogSize.x < displayBounds.x) {
                dialogX = buttonLocation.x - this.button.getSize().x;
            }
            XMLDateControlSWTRenderer.this.dialog.setLocation(dialogX, dialogY);
            XMLDateControlSWTRenderer.this.dialog.open();
        }
    }
}

