/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.renderer;

import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;

public class EMFFormsSpreadsheetViewRenderer
extends EMFFormsAbstractSpreadsheetRenderer<VView> {
    private final EMFFormsSpreadsheetRendererFactory rendererFactory;
    private final ReportService reportService;

    public EMFFormsSpreadsheetViewRenderer(EMFFormsSpreadsheetRendererFactory rendererFactory, ReportService reportService) {
        this.rendererFactory = rendererFactory;
        this.reportService = reportService;
    }

    public int render(Workbook workbook, VView vContainer, ViewModelContext viewModelContext, EMFFormsSpreadsheetRenderTarget eMFFormsSpreadsheetRenderTarget) {
        int numberRenderedColumns = 0;
        for (VContainedElement containedElement : vContainer.getChildren()) {
            try {
                EMFFormsAbstractSpreadsheetRenderer renderer = this.rendererFactory.getRendererInstance((VElement)containedElement, viewModelContext);
                int renderedColumns = renderer.render(workbook, (VElement)containedElement, viewModelContext, eMFFormsSpreadsheetRenderTarget);
                eMFFormsSpreadsheetRenderTarget.setColumn(eMFFormsSpreadsheetRenderTarget.getColumn() + renderedColumns);
                numberRenderedColumns += renderedColumns;
            }
            catch (EMFFormsNoRendererException ex) {
                this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
            }
        }
        return numberRenderedColumns;
    }
}

