/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.fx;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.model.common.ECPStaticRendererTester;
import org.eclipse.emf.ecp.view.model.internal.fx.ECPRendererDescription;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFX;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class RendererFactoryImpl
implements RendererFactory {
    private static final String RENDER_EXTENSION = "org.eclipse.emf.ecp.view.model.fx.renderer";
    private static final String TEST_DYNAMIC = "dynamicTest";
    private static final String TEST_STATIC = "staticTest";
    private static final String TESTER_PRIORITY = "priority";
    private static final String TESTER_VELEMENT = "element";
    private static final String RENDERER_TESTER = "testClass";
    private final Set<ECPRendererDescription> rendererDescriptors = new LinkedHashSet<ECPRendererDescription>();
    private ReportService reportService;
    private static RendererFactoryImpl INSTANCE;

    private RendererFactoryImpl() {
        this.readRenderer();
    }

    private void readRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class<RendererFX<VElement>> rendererClass = RendererFactoryImpl.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    LinkedHashSet<ECPRendererTester> tester = new LinkedHashSet<ECPRendererTester>();
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement testerExtension = iConfigurationElementArray2[n6];
                        if (TEST_DYNAMIC.equals(testerExtension.getName())) {
                            tester.add((ECPRendererTester)testerExtension.createExecutableExtension(RENDERER_TESTER));
                        } else if (TEST_STATIC.equals(testerExtension.getName())) {
                            int priority = Integer.parseInt(testerExtension.getAttribute(TESTER_PRIORITY));
                            String vElement = testerExtension.getAttribute(TESTER_VELEMENT);
                            Class supportedEObject = RendererFactoryImpl.loadClass(testerExtension.getContributor().getName(), vElement);
                            tester.add((ECPRendererTester)new ECPStaticRendererTester(priority, supportedEObject));
                        }
                        ++n6;
                    }
                    this.rendererDescriptors.add(new ECPRendererDescription(rendererClass, tester));
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    public static RendererFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RendererFactoryImpl();
        }
        return INSTANCE;
    }

    @Override
    public RendererFX<VElement> getRenderer(VElement vElement, ViewModelContext viewContext) {
        int highestPriority = -1;
        RendererFX bestCandidate = null;
        for (ECPRendererDescription description : this.rendererDescriptors) {
            int currentPriority = -1;
            for (ECPRendererTester tester : description.getTester()) {
                int testerPriority = tester.isApplicable(vElement, viewContext);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
            }
            if (currentPriority <= highestPriority) continue;
            highestPriority = currentPriority;
            try {
                bestCandidate = (RendererFX)((Object)description.getRenderer().getConstructors()[0].newInstance(vElement, viewContext, this.getReportService()));
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return bestCandidate;
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(RendererFactoryImpl.class).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
            this.reportService = (ReportService)bundleContext.getService(serviceReference);
        }
        return this.reportService;
    }
}

