/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.horizontal.fx;

import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.eclipse.emf.ecp.view.model.internal.fx.GridCellFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFXFactory;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFX;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.horizontal.model.VHorizontalLayout;
import org.eclipse.emf.ecp.view.spi.model.VContainedContainer;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.common.report.ReportService;

public class HorizontalLayoutRendererFX
extends RendererFX<VHorizontalLayout> {
    private GridDescriptionFX gridDescription;

    public HorizontalLayoutRendererFX(VHorizontalLayout vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
    }

    public GridDescriptionFX getGridDescription() {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFXFactory.INSTANCE.createSimpleGrid(1, 1, (RendererFX)this);
        }
        return this.gridDescription;
    }

    protected Node renderNode(GridCellFX cell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getColumn() != 0) {
            return null;
        }
        VHorizontalLayout vHorizontalLayout = (VHorizontalLayout)this.getVElement();
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"horizontal");
        int gridColumn = 0;
        for (VContainedElement composite : vHorizontalLayout.getChildren()) {
            RendererFX compositeRenderer = RendererFactory.INSTANCE.getRenderer((VElement)composite, this.getViewModelContext());
            GridDescriptionFX rendererGrid = compositeRenderer.getGridDescription();
            int rows = rendererGrid.getRows();
            int columns = rendererGrid.getColumns();
            int i = 0;
            while (i < rows) {
                HBox hBox = new HBox();
                int j = 0;
                while (j < columns) {
                    Node node = compositeRenderer.render((GridCellFX)rendererGrid.getGrid().get(i * columns + j));
                    hBox.getChildren().add((Object)node);
                    if (columns - 1 == j) {
                        HBox.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                    }
                    ++j;
                }
                grid.add((Node)hBox, gridColumn++, 0);
                GridPane.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
                if (VContainedContainer.class.isInstance(composite)) {
                    GridPane.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
                }
                ++i;
            }
        }
        return grid;
    }
}

