/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.renderer.fx;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecp.controls.renderer.fx.AbstractDateRendererFX;

public class XmlDateRendererFX
extends AbstractDateRendererFX {
    @Override
    protected UpdateValueStrategy getModelToTargetStrategy() {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)value;
                Date date = gregorianCalendar.toGregorianCalendar().getTime();
                Instant ins = Instant.ofEpochMilli(date.getTime());
                LocalDate result = LocalDateTime.ofInstant(ins, ZoneId.systemDefault()).toLocalDate();
                return result;
            }
        };
    }

    @Override
    protected UpdateValueStrategy getTargetToModelStrategy() {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                LocalDate localDate = (LocalDate)value;
                Instant ins = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                Date date = Date.from(ins);
                Calendar targetCal = Calendar.getInstance();
                targetCal.setTime(date);
                XMLGregorianCalendar result = null;
                try {
                    result = DatatypeFactory.newInstance().newXMLGregorianCalendar();
                    result.setYear(targetCal.get(1));
                    result.setMonth(targetCal.get(2) + 1);
                    result.setDay(targetCal.get(5));
                    result.setTimezone(Integer.MIN_VALUE);
                }
                catch (DatatypeConfigurationException ex) {
                    ex.printStackTrace();
                }
                return result;
            }
        };
    }
}

