/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.editor.Components;
import org.eclipse.ease.modules.unittest.ui.editor.Description;
import org.eclipse.ease.modules.unittest.ui.editor.SetupTeardown;
import org.eclipse.ease.modules.unittest.ui.editor.Variables;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class TestSuiteEditor
extends FormEditor {
    public static final String EDITOR_ID = "org.eclipse.ease.editor.suiteEditor";
    private StructuredTextEditor fSourceEditor;
    private int fSourceEditorIndex;
    private boolean fSourceDirty = false;
    private TestSuiteModel fModel;
    private int fCurrentPage = -1;
    private boolean fDirty = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            this.fModel = new TestSuiteModel(((FileEditorInput)input).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.firePropertyChange(1);
    }

    protected void addPages() {
        this.fSourceEditor = new StructuredTextEditor();
        this.fSourceEditor.setEditorPart((IEditorPart)this);
        try {
            this.addPage((IFormPage)new Components(this, "some ID", "Components"));
            this.addPage((IFormPage)new Description(this, "some id4", "Description"));
            this.addPage((IFormPage)new Variables(this, "some ID2", "Variables"));
            this.addPage((IFormPage)new SetupTeardown(this, "some id3", "Setup"));
            this.fSourceEditorIndex = this.addPage((IEditorPart)this.fSourceEditor, this.getEditorInput());
            this.setPageText(this.fSourceEditorIndex, "Source");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                TestSuiteEditor.this.fSourceDirty = true;
            }
        });
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() != this.fSourceEditorIndex) {
            this.updateSourceFromModel();
        }
        this.fSourceEditor.doSave(monitor);
        this.fDirty = false;
    }

    protected void pageChange(int newPageIndex) {
        if (this.fCurrentPage == this.fSourceEditorIndex && this.fSourceDirty) {
            this.updateModelFromSource();
        }
        if (newPageIndex == this.fSourceEditorIndex && this.fDirty) {
            this.updateSourceFromModel();
        }
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
        this.fCurrentPage = this.getActivePage();
    }

    private void updateModelFromSource() {
        this.fModel.load(this.getDocument().get());
        this.fSourceDirty = false;
    }

    private void updateSourceFromModel() {
        this.getDocument().set(this.fModel.toMemento().toString());
        this.fDirty = false;
    }

    private IDocument getDocument() {
        IDocumentProvider provider = this.fSourceEditor.getDocumentProvider();
        return provider.getDocument((Object)this.getEditorInput());
    }

    public TestSuiteModel getModel() {
        return this.fModel;
    }

    public void setDirty() {
        this.fDirty = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return super.isDirty() | this.fDirty;
    }

    public String getTitle() {
        if (this.getModel() != null) {
            return this.getModel().getFile().getName();
        }
        return super.getTitle();
    }
}

