/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.unittest.AssertionException;
import org.eclipse.ease.lang.unittest.DefaultAssertion;
import org.eclipse.ease.lang.unittest.IAssertion;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.ICode;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.reporters.IReportGenerator;
import org.eclipse.ease.lang.unittest.reporters.ReportTools;
import org.eclipse.ease.lang.unittest.runtime.IMetadata;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestClass;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IScriptFunctionModifier;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;

public class UnitTestModule
extends AbstractScriptModule
implements IScriptFunctionModifier {
    private static final String ASSERTION_FUNCION_NAME = "assertion";
    private ITestClass fCurrentTestClass = null;
    private ITest fCurrentTest = null;
    private boolean fThrowOnFailure = false;
    private ITestFile fInjectedTestFile;
    private ITestSuite fInjectedTestSuite;

    @WrapToScript
    public final void startTest(String title, @ScriptParameter(defaultValue="") String description) {
        ITestContainer container = this.fCurrentTestClass;
        if (container == null) {
            ITestFile testFile = this.getTestFile();
            container = testFile != null ? testFile : IRuntimeFactory.eINSTANCE.createTestFile();
        }
        this.fCurrentTest = IRuntimeFactory.eINSTANCE.createTest();
        this.fCurrentTest.setName(title);
        this.fCurrentTest.setDescription(description);
        this.fCurrentTest.setEntityStatus(TestStatus.RUNNING);
        if (this.getScriptEngine() instanceof IDebugEngine) {
            this.fCurrentTest.setStackTrace(((IDebugEngine)this.getScriptEngine()).getStackTrace());
        }
        container.getChildren().add((Object)this.fCurrentTest);
    }

    @WrapToScript
    public final void endTest() {
        if (this.fCurrentTest != null) {
            this.fCurrentTest.setEntityStatus(TestStatus.PASS);
            this.fCurrentTest = null;
        }
    }

    @WrapToScript
    public ITestSuite getTestSuite() {
        if (this.getTestFile() != null) {
            return this.getTestFile().getTestSuite();
        }
        Object testSuite = this.getScriptEngine().getVariable("__EASE_UnitTest_Suite");
        if (!(testSuite instanceof ITestSuite) && this.isPythonEngine()) {
            this.getScriptEngine().inject((Object)(String.valueOf(EnvironmentModule.getWrappedVariableName((Object)((Object)this))) + ".setTestSuite(__EASE_UnitTest_Suite)"));
            testSuite = this.fInjectedTestSuite;
            this.fInjectedTestSuite = null;
        }
        return testSuite instanceof ITestSuite ? (ITestSuite)testSuite : null;
    }

    public void setTestSuite(ITestSuite testSuite) {
        this.fInjectedTestSuite = testSuite;
    }

    @WrapToScript
    public ITestFile getTestFile() {
        Object testFile = this.getScriptEngine().getVariable("__EASE_UnitTest_File");
        if (!(testFile instanceof ITestFile) && this.isPythonEngine()) {
            this.getScriptEngine().inject((Object)(String.valueOf(EnvironmentModule.getWrappedVariableName((Object)((Object)this))) + ".setTestFile(__EASE_UnitTest_File)"));
            testFile = this.fInjectedTestFile;
            this.fInjectedTestFile = null;
        }
        return testFile instanceof ITestFile ? (ITestFile)testFile : null;
    }

    public void setTestFile(ITestFile testFile) {
        this.fInjectedTestFile = testFile;
    }

    private boolean isPythonEngine() {
        for (ScriptType scriptType : this.getScriptEngine().getDescription().getSupportedScriptTypes()) {
            if (!"Python".equals(scriptType.getName())) continue;
            return true;
        }
        return false;
    }

    @WrapToScript
    public void addMetaData(String name, Object value) {
        IMetadata metadata = IRuntimeFactory.eINSTANCE.createMetadata();
        metadata.setKey(name);
        metadata.setValue(value);
        if (this.getScriptEngine() instanceof IDebugEngine) {
            metadata.setStackTrace(((IDebugEngine)this.getScriptEngine()).getStackTrace());
        }
        if (this.fCurrentTest != null) {
            this.fCurrentTest.getMetadata().add((Object)metadata);
        } else if (this.getTestFile() != null) {
            this.getTestFile().getMetadata().add((Object)metadata);
        } else if (this.getTestSuite() != null) {
            this.getTestSuite().getMetadata().add((Object)metadata);
        } else {
            throw new RuntimeException("No test entity availabe. Nowhere to store metadata to");
        }
    }

    @WrapToScript
    public static IAssertion assertEquals(Object expected, Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        if (expected != null) {
            return new DefaultAssertion(expected.equals(actual), errorDescription == null ? "Objects do not match: expected <" + expected + ">, actual <" + actual + ">" : errorDescription.toString());
        }
        return UnitTestModule.assertNull(actual, errorDescription);
    }

    @WrapToScript
    public static IAssertion assertMatch(String pattern, String candidate, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String errorMessage) {
        if (Pattern.matches(pattern, candidate)) {
            return IAssertion.VALID;
        }
        return new DefaultAssertion(errorMessage != null ? errorMessage : "\"" + candidate + "\" does not match pattern \"" + pattern + "\"");
    }

    @WrapToScript
    public static IAssertion assertNotEquals(Object expected, Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        if (expected != null) {
            return new DefaultAssertion(!expected.equals(actual), errorDescription == null ? "Objects match" : errorDescription.toString());
        }
        return UnitTestModule.assertNotNull(actual, errorDescription);
    }

    @WrapToScript
    public static IAssertion assertNull(Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual == null, errorDescription == null ? "Object is not null, actual <" + actual + ">" : errorDescription.toString());
    }

    @WrapToScript
    public static IAssertion assertNotNull(Object actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual != null, errorDescription == null ? "Object is null" : errorDescription.toString());
    }

    @WrapToScript
    public static IAssertion assertTrue(Boolean actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual, errorDescription == null ? "Value is false" : errorDescription.toString());
    }

    @WrapToScript
    public static IAssertion assertFalse(Boolean actual, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object errorDescription) {
        return new DefaultAssertion(actual == false, errorDescription == null ? "Value is true" : errorDescription.toString());
    }

    public void setThrowOnFailure(boolean throwOnFailure) {
        this.fThrowOnFailure = throwOnFailure;
    }

    public String getPreExecutionCode(Method method) {
        return "";
    }

    public String getPostExecutionCode(Method method) {
        if ("JavaScript".equals(((ScriptType)this.getScriptEngine().getDescription().getSupportedScriptTypes().get(0)).getName())) {
            if (IAssertion.class.isAssignableFrom(method.getReturnType())) {
                return String.valueOf(EnvironmentModule.getWrappedVariableName((Object)((Object)this))) + "." + ASSERTION_FUNCION_NAME + "(" + "__result" + ");\n";
            }
        } else if ("Python".equals(((ScriptType)this.getScriptEngine().getDescription().getSupportedScriptTypes().get(0)).getName()) && IAssertion.class.isAssignableFrom(method.getReturnType())) {
            return String.valueOf(EnvironmentModule.getWrappedVariableName((Object)((Object)this))) + "." + ASSERTION_FUNCION_NAME + "(" + "__result" + ")\n";
        }
        return "";
    }

    @WrapToScript
    public final void assertion(IAssertion reason) throws AssertionException {
        if (!reason.isValid()) {
            if (this.fThrowOnFailure) {
                throw new AssertionException(reason.toString());
            }
            this.failure(reason.toString());
        }
    }

    public ITestContainer addTestClass(String className) {
        if (this.fCurrentTestClass != null) {
            this.fCurrentTestClass.setEntityStatus(TestStatus.FINISHED);
            this.fCurrentTestClass = null;
        }
        if (className != null) {
            ITestFile testFile = this.getTestFile();
            this.fCurrentTestClass = IRuntimeFactory.eINSTANCE.createTestClass();
            this.fCurrentTestClass.setName(className);
            this.fCurrentTestClass.setEntityStatus(TestStatus.RUNNING);
            if (this.getScriptEngine() instanceof IDebugEngine) {
                this.fCurrentTestClass.setStackTrace(((IDebugEngine)this.getScriptEngine()).getStackTrace());
            }
            testFile.getChildren().add((Object)this.fCurrentTestClass);
        }
        return this.fCurrentTestClass;
    }

    @WrapToScript
    public void ignoreTest(@ScriptParameter(defaultValue="") String reason) {
        if (this.fCurrentTest != null) {
            this.addResult(TestStatus.DISABLED, reason, null);
        }
    }

    @WrapToScript
    public void failure(String message) {
        this.failure(message, null);
    }

    public void failure(String message, ScriptStackTrace stackTrace) {
        ITestSuiteDefinition definition;
        ITestSuiteDefinition iTestSuiteDefinition = definition = this.getTestSuite() != null ? this.getTestSuite().getDefinition() : null;
        if (definition != null && definition.getFlag(Flag.PROMOTE_FAILURE_TO_ERROR, false).booleanValue()) {
            this.error(message, stackTrace);
        } else {
            this.addResult(TestStatus.FAILURE, message, stackTrace);
        }
    }

    private void addResult(TestStatus status, String message, ScriptStackTrace stackTrace) {
        ITestResult result = IRuntimeFactory.eINSTANCE.createTestResult();
        result.setStatus(status);
        result.setMessage(message);
        if (stackTrace != null) {
            result.setStackTrace(stackTrace);
        } else if (this.getScriptEngine() instanceof IDebugEngine) {
            result.setStackTrace(((IDebugEngine)this.getScriptEngine()).getStackTrace());
        }
        this.getTest().getResults().add((Object)result);
    }

    @WrapToScript
    public ITest getTest() {
        if (this.fCurrentTest == null) {
            if (this.getTestFile() != null) {
                return this.getTestFile().getTest("[Global Scope]");
            }
            if (this.getTestSuite() != null) {
                return this.getTestSuite().getTest("[Global Scope]");
            }
            return IRuntimeFactory.eINSTANCE.createTest();
        }
        return this.fCurrentTest;
    }

    @WrapToScript
    public void error(String message) throws AssertionException {
        throw new AssertionException(message);
    }

    public void error(String message, ScriptStackTrace stackTrace) {
        this.addResult(TestStatus.ERROR, message, stackTrace);
    }

    @WrapToScript
    public void setTestTimeout(long timeout) {
        if (this.fCurrentTest != null) {
            this.getTest().setDurationLimit(timeout);
        }
    }

    @WrapToScript
    public Object executeUserCode(String location) throws Exception {
        ITestSuiteDefinition definition;
        ITestSuiteDefinition iTestSuiteDefinition = definition = this.getTestSuite() != null ? this.getTestSuite().getDefinition() : null;
        if (definition != null) {
            ICode customCode = definition.getCustomCode(location);
            if (customCode != null) {
                return this.getScriptEngine().inject((Object)new Script(customCode.getLocation(), (Object)customCode.getContent()));
            }
            throw new Exception("No user specific code for \"" + location + "\" found.");
        }
        throw new Exception("No user specific code for \"" + location + "\" found.");
    }

    @WrapToScript
    public static String[] getReportTypes() {
        return ReportTools.getReportTemplates().toArray(new String[0]);
    }

    @WrapToScript
    public void createReport(String reportType, ITestEntity suite, Object fileLocation, String title, String description) throws IOException, CoreException {
        IReportGenerator report = ReportTools.getReport(reportType);
        if (report == null) {
            throw new IOException("Report does not contain any data");
        }
        String reportData = report.createReport(title, description, suite);
        this.saveDataToFile(reportData.getBytes(), fileLocation);
    }

    @WrapToScript
    public ITestSuiteDefinition loadTestSuiteDefinition(Object location) throws IOException {
        Object resolvedLocation = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        return UnitTestHelper.loadTestSuite(ResourceTools.getInputStream((Object)resolvedLocation));
    }

    @WrapToScript
    public void saveTestSuiteDefinition(ITestSuiteDefinition testsuite, Object fileLocation) throws IOException, CoreException {
        byte[] testSuiteData = UnitTestHelper.serializeTestSuite(testsuite);
        this.saveDataToFile(testSuiteData, fileLocation);
    }

    private void saveDataToFile(byte[] data, Object fileLocation) throws IOException, CoreException {
        Object file = ResourceTools.resolve((Object)fileLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof IFile) {
            if (((IFile)file).exists()) {
                ((IFile)file).setContents((InputStream)new ByteArrayInputStream(data), 3, null);
            } else {
                ((IFile)file).create((InputStream)new ByteArrayInputStream(data), true, null);
            }
        } else if (file instanceof File) {
            FileOutputStream outputStream = new FileOutputStream((File)file);
            outputStream.write(data);
            outputStream.close();
        } else {
            throw new IOException("Could not find file: " + fileLocation);
        }
    }
}

