/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.tools;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.ease.Logger;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractLaunchDelegate
implements ILaunchShortcut,
ILaunchShortcut2,
ILaunchConfigurationDelegate,
ILaunchConfigurationDelegate2 {
    public final void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    public final void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public final IResource getLaunchableResource(IEditorPart editorpart) {
        IEditorInput input = editorpart.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    public final IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    return (IResource)element;
                }
                Object adaptedFile = Platform.getAdapterManager().getAdapter(element, IResource.class);
                if (adaptedFile instanceof IFile) {
                    return (IResource)adaptedFile;
                }
                ++n2;
            }
        }
        return null;
    }

    public final ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfigurations(this.getLaunchableResource(editorpart), "run");
    }

    public final ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfigurations(this.getLaunchableResource(selection), "run");
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    protected ILaunchConfiguration[] getLaunchConfigurations(IResource resource, String mode) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationId());
        String resourceLocation = ResourceTools.toAbsoluteLocation((Object)resource, null);
        if (resourceLocation != null) {
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    String configurationUri = this.getFileLocation(configuration);
                    if (resourceLocation.equals(configurationUri)) {
                        configurations.add(configuration);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
    }

    private void launch(IResource file, String mode) {
        if (file instanceof IFile) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
            try {
                ILaunchConfiguration[] configurations = this.getLaunchConfigurations(file, mode);
                if (configurations.length == 0) {
                    ILaunchConfiguration configuration = this.createLaunchConfiguration(file, mode);
                    configurations = new ILaunchConfiguration[]{configuration};
                }
                configurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Launch Error", (String)("Could not launch \"" + file + "\""));
                Logger.error((String)"org.eclipse.ease.ui", (String)("Could not launch \"" + file + "\""), (Throwable)e);
            }
        }
    }

    protected abstract ILaunchConfiguration createLaunchConfiguration(IResource var1, String var2) throws CoreException;

    protected abstract String getFileLocation(ILaunchConfiguration var1) throws CoreException;

    protected abstract String getLaunchConfigurationId();
}

