/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.ease.tools.StringTools;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.launching.LaunchConstants;
import org.eclipse.ease.ui.tools.AbstractLaunchDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EaseLaunchDelegate
extends AbstractLaunchDelegate {
    private static final String LAUNCH_CONFIGURATION_ID = "org.eclipse.ease.launchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String fileLocation = this.getFileLocation(configuration);
        Object resource = ResourceTools.resolve((Object)fileLocation);
        if (ResourceTools.isFile((Object)resource)) {
            String engineID = configuration.getAttribute("Script engine", "");
            IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
            EngineDescription engineDescription = scriptService.getEngineByID(engineID);
            if ("debug".equals(mode) && !engineDescription.supportsDebugging()) {
                engineDescription = null;
                ScriptType scriptType = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)resource, null));
                if (scriptType != null) {
                    List engines = scriptService.getEngines(scriptType.getName());
                    for (EngineDescription description : engines) {
                        if (!description.supportsDebugging()) continue;
                        engineDescription = description;
                        break;
                    }
                }
                if (engineDescription != null) {
                    RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                        public void run() {
                            boolean confirmEngineSwitch = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Configuration change needed", (String)"The currently selected script engine does not support debugging. However an alternative engine is available. Do you want to debug your script using that alternative engine?");
                            this.setResult(confirmEngineSwitch);
                        }
                    };
                    Display.getDefault().syncExec((Runnable)runnable);
                    if (!((Boolean)runnable.getResult()).booleanValue()) {
                        return;
                    }
                } else {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Launch error", (String)("No debug engine available for \"" + resource + "\"")));
                    return;
                }
            }
            IScriptEngine engine = engineDescription.createEngine();
            engine.setTerminateOnIdle(true);
            ScriptConsole console = ScriptConsole.create(String.valueOf(engine.getName()) + ": " + resource, engine);
            engine.setOutputStream((OutputStream)console.getOutputStream());
            engine.setErrorStream((OutputStream)console.getErrorStream());
            engine.setInputStream((InputStream)console.getInputStream());
            if ("debug".equals(mode)) {
                this.setupDebugger(engine, configuration, launch);
            }
            Collection<String> libraries = LaunchConstants.getLibraries(configuration);
            for (String libraryPath : libraries) {
                try {
                    engine.registerJar(new URL(libraryPath));
                }
                catch (MalformedURLException e) {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Launch error", (String)("Invalid URL for the library \"" + libraryPath + "\"")));
                    return;
                }
            }
            String parameterString = configuration.getAttribute("Startup parameters", "").trim();
            String[] parameters = StringTools.parseArguments((String)parameterString);
            engine.setVariable("argv", (Object)parameters);
            engine.executeAsync(resource);
            engine.schedule();
            if (launch instanceof IExecutionListener) {
                engine.addExecutionListener((IExecutionListener)launch);
            }
        } else {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Launch error", (String)("File could not be found: \"" + fileLocation + "\"")));
        }
    }

    @Override
    protected ILaunchConfiguration createLaunchConfiguration(IResource file, String mode) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_ID);
        ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, file.getName());
        configuration.setAttribute("File location", ResourceTools.toAbsoluteLocation((Object)file, null));
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ScriptType scriptType = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)file, null));
        List engines = scriptType == null ? Collections.emptyList() : scriptType.getEngines();
        if (engines.isEmpty()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        configuration.setAttribute("Script engine", ((EngineDescription)engines.iterator().next()).getID());
        if ("debug".equals(mode)) {
            configuration.setAttribute("Suspend on startup", true);
        }
        configuration.doSave();
        return configuration;
    }

    @Override
    protected String getFileLocation(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("File location", "");
    }

    @Override
    protected String getLaunchConfigurationId() {
        return LAUNCH_CONFIGURATION_ID;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new EASELaunch(configuration, mode, null);
    }

    private void setupDebugger(IScriptEngine engine, ILaunchConfiguration configuration, ILaunch launch) {
        if (engine instanceof IDebugEngine) {
            boolean suspendOnStartup = false;
            try {
                suspendOnStartup = configuration.getAttribute("Suspend on startup", false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            boolean suspendOnScriptLoad = false;
            try {
                suspendOnScriptLoad = configuration.getAttribute("Suspend on script load", false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            boolean showDynamicCode = false;
            try {
                showDynamicCode = configuration.getAttribute("Display dynamic code", false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ((IDebugEngine)engine).setupDebugger(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        }
    }

    private class EASELaunch
    extends Launch
    implements IExecutionListener {
        private boolean fIsTerminated;

        public EASELaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
            super(launchConfiguration, mode, locator);
            this.fIsTerminated = false;
        }

        public boolean isTerminated() {
            return this.fIsTerminated || super.isTerminated();
        }

        public void notify(IScriptEngine engine, Script script, int status) {
            if (2 == status) {
                this.fIsTerminated = true;
                if (DebugPlugin.getDefault() != null) {
                    this.fireTerminate();
                    if ("run".equals(this.getLaunchMode())) {
                        this.getLaunchManager().removeLaunch((ILaunch)this);
                    }
                }
            }
        }
    }
}

