/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.views;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.modules.unittest.ITestListener;
import org.eclipse.ease.modules.unittest.components.Test;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestResult;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.Activator;
import org.eclipse.ease.modules.unittest.ui.sourceprovider.TestSuiteSource;
import org.eclipse.ease.modules.unittest.ui.views.MultiSelectionProvider;
import org.eclipse.ease.modules.unittest.ui.views.SuiteRuntimeInformation;
import org.eclipse.ease.modules.unittest.ui.views.TestFileContentProvider;
import org.eclipse.ease.modules.unittest.ui.views.TestSuiteContentProvider;
import org.eclipse.ease.modules.unittest.ui.views.TestSuiteLabelProvider;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.tools.DecoratedLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.ExpandAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;

public class UnitTestView
extends ViewPart
implements ITestListener,
IConsoleListener {
    public static final String VIEW_ID = "org.eclipse.ease.views.unittest";
    public static final String TEST_STATUS_PROPERTY = "test status";
    private static final String XML_CURRENT_SUITE = "currentSuite";
    private static final Object STATISTICS_TESTFILES_FINISHED = "testFiles";
    private static final Object STATISTICS_TEST_ERROR = "test errors";
    private static final Object STATISTICS_TEST_FAILURE = "test failures";
    private static final Object STATISTICS_TEST_VALID = "valid tests";
    private static final Object STATISTICS_TESTFILE_COUNT = "testFile count";
    private static final Object STATISTICS_TEST_FINISHED = "test count";
    private ProgressBar fProgressBar;
    private TreeViewer fFileTreeViewer;
    private TreeViewer fTestTreeViewer;
    private SashForm sashForm;
    private int[] fSashWeights = new int[]{70, 30};
    private IMemento mMemento;
    private CollapseAllHandler mCollapseAllHandler;
    private ExpandAllHandler mExpandAllHandler;
    private Label lblTimeLeftText;
    private LocalResourceManager fResourceManager;
    private final UpdateUI fUIUpdater = new UpdateUI();
    private final Statistics fStatistics = new Statistics();
    private Label lblErrorCount;
    private Label lblFailureCount;
    private SuiteRuntimeInformation fRuntimeInformation = null;
    private Label lblTimeLeft;
    private ScriptConsole fConsole = null;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.mMemento = memento;
        super.init(site, memento);
    }

    public void createPartControl(Composite parent) {
        IMemento currentSuiteNode;
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(8, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        Label lblErrorIcon = new Label(composite, 0);
        GridData gdLblErrorIcon = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblErrorIcon.horizontalIndent = 50;
        lblErrorIcon.setLayoutData((Object)gdLblErrorIcon);
        lblErrorIcon.setImage(this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/status_error.png")));
        Label lblErrors = new Label(composite, 0);
        lblErrors.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblErrors.setAlignment(0x1000000);
        lblErrors.setText("Errors:");
        this.lblErrorCount = new Label(composite, 0);
        GridData gd_lblErrorCount = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblErrorCount.horizontalIndent = 20;
        this.lblErrorCount.setLayoutData((Object)gd_lblErrorCount);
        Label lblFailureIcon = new Label(composite, 0);
        GridData gdLblFailureIcon = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblFailureIcon.horizontalIndent = 50;
        lblFailureIcon.setLayoutData((Object)gdLblFailureIcon);
        lblFailureIcon.setImage(this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/status_failure.png")));
        Label lblFailures = new Label(composite, 0);
        lblFailures.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFailures.setAlignment(0x1000000);
        lblFailures.setText("Failures:");
        this.lblFailureCount = new Label(composite, 0);
        GridData gdLblFailureCount = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblFailureCount.horizontalIndent = 20;
        this.lblFailureCount.setLayoutData((Object)gdLblFailureCount);
        this.lblTimeLeftText = new Label(composite, 0);
        GridData gdLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLabel.horizontalIndent = 50;
        this.lblTimeLeftText.setLayoutData((Object)gdLabel);
        this.lblTimeLeftText.setText("Time left: ");
        this.lblTimeLeftText.setVisible(false);
        this.lblTimeLeft = new Label(composite, 0);
        GridData gdLblTimeLeft = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblTimeLeft.horizontalIndent = 20;
        this.lblTimeLeft.setLayoutData((Object)gdLblTimeLeft);
        this.lblTimeLeft.setVisible(false);
        this.fProgressBar = new ProgressBar(parent, 0);
        this.fProgressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.sashForm = new SashForm(parent, 0);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sashForm.setOrientation(512);
        this.fFileTreeViewer = new TreeViewer((Composite)this.sashForm, 2050);
        this.fFileTreeViewer.setContentProvider((IContentProvider)new TestSuiteContentProvider());
        this.fFileTreeViewer.setComparator(new ViewerComparator(){

            public final int category(Object element) {
                if (element instanceof TestFile) {
                    return 1;
                }
                return 0;
            }
        });
        TestSuiteLabelProvider provider = new TestSuiteLabelProvider(this.fResourceManager);
        this.fFileTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratedLabelProvider((ILabelProvider)provider));
        this.fFileTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (element instanceof TestFile) {
                        Object file = ((TestFile)element).getFile();
                        if (file instanceof IFile) {
                            UIModule.showEditor((IFile)((IFile)((TestFile)element).getFile()));
                        }
                    } else if (element instanceof TestSuite) {
                        UIModule.showEditor((IFile)((TestSuite)element).getModel().getFile());
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.fFileTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof TestComposite) {
                    UnitTestView.this.fTestTreeViewer.setInput(element);
                    if (UnitTestView.this.sashForm.getWeights()[1] == 0) {
                        UnitTestView.this.sashForm.setWeights(UnitTestView.this.fSashWeights);
                    }
                    UnitTestView.this.fTestTreeViewer.refresh();
                } else {
                    UnitTestView.this.fTestTreeViewer.setInput(null);
                    if (UnitTestView.this.sashForm.getWeights()[1] != 0) {
                        UnitTestView.this.fSashWeights = UnitTestView.this.sashForm.getWeights();
                    }
                    int[] nArray = new int[2];
                    nArray[0] = 100;
                    UnitTestView.this.sashForm.setWeights(nArray);
                }
            }
        });
        this.fTestTreeViewer = this.createTestArea((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{1, 1});
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.fFileTreeViewer.getTree());
        this.fFileTreeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fFileTreeViewer);
        MenuManager menuManager2 = new MenuManager();
        Menu menu2 = menuManager2.createContextMenu((Control)this.fFileTreeViewer.getTree());
        this.fTestTreeViewer.getTree().setMenu(menu2);
        this.getSite().registerContextMenu(menuManager2, (ISelectionProvider)this.fTestTreeViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.mCollapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.fFileTreeViewer);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.mCollapseAllHandler);
        this.mExpandAllHandler = new ExpandAllHandler((AbstractTreeViewer)this.fFileTreeViewer);
        handlerService.activateHandler("org.eclipse.ui.navigate.expandAll", (IHandler)this.mExpandAllHandler);
        if (this.mMemento != null && (currentSuiteNode = this.mMemento.getChild(XML_CURRENT_SUITE)) != null) {
            Path path = new Path(currentSuiteNode.getTextData());
            IFile suiteFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            try {
                this.loadSuite(new TestSuite(new TestSuiteModel(suiteFile)));
            }
            catch (Exception exception) {}
        }
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener((IConsoleListener)this);
        MultiSelectionProvider selectionProvider = new MultiSelectionProvider();
        selectionProvider.addSelectionProvider((ISelectionProvider)this.fFileTreeViewer);
        selectionProvider.addSelectionProvider((ISelectionProvider)this.fTestTreeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
    }

    private TreeViewer createTestArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        composite.setLayout((Layout)layout);
        final TreeViewer viewer = new TreeViewer(composite, 67584);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (!(element instanceof Test)) return;
                List messages = ((Test)element).getMessages();
                List trace = messages != null && !messages.isEmpty() ? ((TestResult)messages.get(0)).getStackTrace() : ((Test)element).getTestLocation();
                if (trace != null) {
                    for (IScriptDebugFrame traceElement : trace) {
                        Object file = traceElement.getScript().getFile();
                        if (!(file instanceof IFile) || !((IFile)file).exists()) continue;
                        try {
                            int line = Math.max(traceElement.getLineNumber(), 1);
                            ITextEditor textEditor = (ITextEditor)UIModule.showEditor((IFile)((IFile)file));
                            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                            try {
                                textEditor.selectAndReveal(document.getLineOffset(line - 1), document.getLineLength(line - 1));
                                return;
                            }
                            catch (BadLocationException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return;
                }
                Object input = viewer.getInput();
                if (!(input instanceof TestFile)) return;
                try {
                    Object file = ((TestFile)input).getFile();
                    if (!(file instanceof IFile)) return;
                    UIModule.showEditor((IFile)((IFile)((TestFile)input).getFile()));
                    return;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new TestFileContentProvider());
        TreeViewerColumn testColumn = new TreeViewerColumn(viewer, 0);
        testColumn.getColumn().setWidth(100);
        testColumn.getColumn().setText("Test");
        layout.setColumnData((Widget)testColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 50, true));
        testColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Test) {
                    return ((Test)element).getTitle();
                }
                if (element instanceof Map.Entry) {
                    return ((Map.Entry)element).getKey().toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof Map.Entry) {
                    return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/metadata.png"));
                }
                TestStatus status = null;
                if (element instanceof Test) {
                    status = ((Test)element).getStatus();
                } else if (element instanceof TestResult) {
                    status = ((TestResult)element).getStatus();
                }
                if (status != null) {
                    switch (status) {
                        case PASS: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/status_pass.png"));
                        }
                        case ERROR: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/status_error.png"));
                        }
                        case FAILURE: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/status_failure.png"));
                        }
                        case RUNNING: {
                            return UnitTestView.this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/status_running.png"));
                        }
                    }
                    return super.getImage(element);
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof Test && ((Test)element).getDescription() != null && !((Test)element).getDescription().isEmpty()) {
                    return ((Test)element).getDescription();
                }
                return super.getToolTipText(element);
            }
        });
        TreeViewerColumn messageColumn = new TreeViewerColumn(viewer, 0);
        messageColumn.getColumn().setWidth(100);
        messageColumn.getColumn().setText("Message");
        layout.setColumnData((Widget)messageColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(70, 50, true));
        messageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Test) {
                    TestResult message = ((Test)element).getSeverestMessage();
                    if (message != null) {
                        return message.getDescription();
                    }
                    return ((Test)element).getDescription();
                }
                if (element instanceof Map.Entry) {
                    return ((Map.Entry)element).getValue().toString();
                }
                return super.getText(element);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        return viewer;
    }

    public void setFocus() {
    }

    public TreeViewer getFileTreeViewer() {
        return this.fFileTreeViewer;
    }

    public void notify(final Object testObject, TestStatus status) {
        if (testObject instanceof TestSuite && status == TestStatus.RUNNING) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        UnitTestView.this.loadSuite((TestSuite)testObject);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    UnitTestView.this.fStatistics.reset();
                    UnitTestView.this.fStatistics.updateCounter(STATISTICS_TESTFILE_COUNT, ((TestSuite)testObject).getActiveTestCount());
                    UnitTestView.this.fProgressBar.setMaximum(UnitTestView.this.fStatistics.getCounter(STATISTICS_TESTFILE_COUNT));
                    UnitTestView.this.fProgressBar.setSelection(0);
                    UnitTestView.this.fProgressBar.setForeground(null);
                    if (UnitTestView.this.fConsole == null) {
                        UnitTestView.this.fConsole = ScriptConsole.create((String)testObject.toString(), null);
                    }
                    UnitTestView.this.fConsole.clearConsole();
                    UnitTestView.this.fConsole.activate();
                    ((TestSuite)testObject).setOutputStream((OutputStream)UnitTestView.this.fConsole.getOutputStream());
                    ((TestSuite)testObject).setErrorStream((OutputStream)UnitTestView.this.fConsole.getErrorStream());
                    ((TestSuite)testObject).setErrorStream((InputStream)UnitTestView.this.fConsole.getInputStream());
                    UnitTestView.this.lblTimeLeft.setVisible(true);
                    UnitTestView.this.lblTimeLeftText.setVisible(true);
                }
            });
        } else if (status != TestStatus.RUNNING && status != TestStatus.NOT_RUN) {
            if (testObject instanceof Test) {
                if (!((Test)testObject).isTransient()) {
                    this.fStatistics.updateCounter(STATISTICS_TEST_FINISHED, 1);
                }
                if (!((Test)testObject).isTransient() || !((Test)testObject).getMessages().isEmpty()) {
                    switch (status) {
                        case FAILURE: {
                            this.fStatistics.updateCounter(STATISTICS_TEST_FAILURE, 1);
                            break;
                        }
                        case ERROR: {
                            this.fStatistics.updateCounter(STATISTICS_TEST_ERROR, 1);
                            break;
                        }
                        case PASS: {
                            this.fStatistics.updateCounter(STATISTICS_TEST_VALID, 1);
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (testObject instanceof TestFile) {
                this.fStatistics.updateCounter(STATISTICS_TESTFILES_FINISHED, 1);
            }
        }
        this.fUIUpdater.addElement(testObject);
    }

    public StructuredViewer getTableViewer() {
        return this.fTestTreeViewer;
    }

    public void saveState(IMemento memento) {
        IFile file;
        TestSuite suite = this.getCurrentSuite();
        if (suite != null && (file = suite.getModel().getFile()) != null && file.exists()) {
            memento.createChild(XML_CURRENT_SUITE).putTextData(file.getFullPath().toString());
        }
        super.saveState(memento);
    }

    public TestSuite getCurrentSuite() {
        Object suite;
        Object input = this.fFileTreeViewer.getInput();
        if (input instanceof Object[] && ((Object[])input).length > 0 && (suite = ((Object[])input)[0]) instanceof TestSuite) {
            return (TestSuite)suite;
        }
        return null;
    }

    public void loadSuite(TestSuite suite) throws IOException, CoreException {
        TestSuite currentSuite = this.getCurrentSuite();
        if (!suite.equals(currentSuite)) {
            if (currentSuite != null) {
                Activator.getDefault().addRecentFile(currentSuite.getModel().getFile());
                if (this.fRuntimeInformation != null) {
                    this.fRuntimeInformation.save();
                }
            }
            this.fFileTreeViewer.setInput((Object)new Object[]{suite});
            this.fRuntimeInformation = new SuiteRuntimeInformation(suite);
            TestSuiteSource instance = TestSuiteSource.getActiveInstance();
            if (instance != null) {
                instance.setActiveSuite(suite);
            }
            suite.addTestListener((ITestListener)this);
            if (this.fConsole != null) {
                this.fConsole.terminate();
                this.fConsole = null;
            }
        }
        this.fFileTreeViewer.refresh();
        this.fFileTreeViewer.expandAll();
    }

    public void dispose() {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
        this.mCollapseAllHandler.dispose();
        this.mExpandAllHandler.dispose();
        TestSuite currentSuite = this.getCurrentSuite();
        if (currentSuite != null) {
            Activator.getDefault().addRecentFile(currentSuite.getModel().getFile());
        }
        if (this.fRuntimeInformation != null) {
            this.fRuntimeInformation.save();
        }
        super.dispose();
    }

    public void consolesAdded(IConsole[] consoles) {
    }

    public void consolesRemoved(IConsole[] consoles) {
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.equals(this.fConsole)) {
                this.fConsole = null;
            }
            ++n2;
        }
    }

    private static class Statistics {
        private final Map<Object, Integer> mCounters = new HashMap<Object, Integer>();

        private Statistics() {
        }

        public synchronized void updateCounter(Object identifier, int value) {
            if (this.mCounters.containsKey(identifier)) {
                this.mCounters.put(identifier, this.mCounters.get(identifier) + value);
            } else {
                this.mCounters.put(identifier, value);
            }
        }

        public void reset() {
            this.mCounters.clear();
        }

        public synchronized int getCounter(Object identifier) {
            if (this.mCounters.containsKey(identifier)) {
                return this.mCounters.get(identifier);
            }
            return 0;
        }
    }

    private class UpdateUI
    extends UIJob {
        private final List<Object> fElements;

        public UpdateUI() {
            super("Update Script Unit View");
            this.fElements = new ArrayList<Object>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(Object element) {
            List<Object> list = this.fElements;
            synchronized (list) {
                if (this.fElements.isEmpty()) {
                    this.fElements.add(element);
                    this.schedule(300L);
                } else {
                    this.fElements.add(element);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList<Object> localElements;
            List<Object> list = this.fElements;
            synchronized (list) {
                localElements = new ArrayList<Object>(this.fElements);
                this.fElements.clear();
            }
            for (Object element : localElements) {
                TestComposite affectedComposite = null;
                if (element instanceof Test) {
                    affectedComposite = ((Test)element).getParent();
                } else if (element instanceof TestComposite) {
                    affectedComposite = (TestComposite)element;
                }
                while (affectedComposite != null) {
                    UnitTestView.this.fFileTreeViewer.update((Object)affectedComposite, new String[]{UnitTestView.TEST_STATUS_PROPERTY});
                    affectedComposite = affectedComposite.getParent();
                }
            }
            if (UnitTestView.this.fTestTreeViewer.getInput() != null) {
                for (Object element : localElements) {
                    if (!(element instanceof Test)) continue;
                    TestComposite testComposite = ((Test)element).getParent();
                    if (!UnitTestView.this.fTestTreeViewer.getInput().equals(testComposite)) continue;
                    UnitTestView.this.fTestTreeViewer.refresh();
                    break;
                }
            }
            if (!UnitTestView.this.fProgressBar.isDisposed()) {
                UnitTestView.this.lblErrorCount.setText(Integer.toString(UnitTestView.this.fStatistics.getCounter(STATISTICS_TEST_ERROR)));
                UnitTestView.this.lblFailureCount.setText(Integer.toString(UnitTestView.this.fStatistics.getCounter(STATISTICS_TEST_FAILURE)));
                UnitTestView.this.lblFailureCount.getParent().layout();
                UnitTestView.this.fProgressBar.setSelection(UnitTestView.this.fStatistics.getCounter(STATISTICS_TESTFILES_FINISHED));
                UnitTestView.this.lblTimeLeft.setText(this.getEstimatedTime());
                if (UnitTestView.this.fStatistics.getCounter(STATISTICS_TEST_ERROR) > 0 || UnitTestView.this.fStatistics.getCounter(STATISTICS_TEST_FAILURE) > 0) {
                    UnitTestView.this.fProgressBar.setForeground(UnitTestView.this.fResourceManager.createColor(new RGB(170, 0, 0)));
                } else if (UnitTestView.this.fStatistics.getCounter(STATISTICS_TESTFILES_FINISHED) == UnitTestView.this.fStatistics.getCounter(STATISTICS_TESTFILE_COUNT) && UnitTestView.this.fStatistics.getCounter(STATISTICS_TEST_ERROR) == 0 && UnitTestView.this.fStatistics.getCounter(STATISTICS_TEST_FAILURE) == 0) {
                    UnitTestView.this.fProgressBar.setForeground(UnitTestView.this.fResourceManager.createColor(new RGB(0, 170, 0)));
                }
            }
            list = this.fElements;
            synchronized (list) {
                if (!this.fElements.isEmpty()) {
                    this.schedule(1000L);
                }
            }
            return Status.OK_STATUS;
        }

        private String getEstimatedTime() {
            if (UnitTestView.this.getCurrentSuite().getStatus() != TestStatus.RUNNING) {
                UnitTestView.this.lblTimeLeft.setVisible(false);
                UnitTestView.this.lblTimeLeftText.setVisible(false);
                return "";
            }
            if (UnitTestView.this.fRuntimeInformation != null) {
                long time = UnitTestView.this.fRuntimeInformation.getEstimatedTestTime();
                if (time < 0L) {
                    return "calculating...";
                }
                if (time < 60000L) {
                    return new SimpleDateFormat("ss 'seconds'").format(time);
                }
                if (time < 3600000L) {
                    return new SimpleDateFormat("mm:ss").format(time);
                }
                return new SimpleDateFormat("hh:mm:ss").format(time);
            }
            return "unknown";
        }
    }
}

