/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.OnExceptionHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Variable;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.RequestUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class EvaluateOnCallFrameHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();

    @Override
    public void handle(String message, Session session) throws IOException {
        MessageRequest request = (MessageRequest)GSON.fromJson(message, MessageRequest.class);
        ScriptRepository repository = ScriptRepository.getInstance();
        Map<String, Object> params = request.getParams();
        String variableName = (String)params.get("expression");
        Variable.Value variableValue = repository.getVariableValueByName(variableName);
        JSONObject response = new JSONObject();
        try {
            response.put("id", (Object)RequestUtils.getMessageId(message));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("result", variableValue);
            result.put("wasThrown", false);
            response.put("result", result);
        }
        catch (JSONException e) {
            new OnExceptionHandler().handle(e.getMessage(), session);
        }
        MessageDispatcher.sendMessage(response.toString(), session);
    }
}

