/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IMasterRepositoryProvider;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IRepositoryProvider;
import org.eclipse.dirigible.repository.api.RepositoryActivator;
import org.eclipse.dirigible.repository.api.RepositoryCreationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)RepositoryFactory.class.getCanonicalName());
    static IRepositoryProvider localRepositoryProvider;
    static IMasterRepositoryProvider masterRepositoryProvider;
    static List<IRepositoryProvider> repositoryProviders;
    static List<IMasterRepositoryProvider> masterRepositoryProviders;

    static {
        repositoryProviders = new ArrayList<IRepositoryProvider>();
        masterRepositoryProviders = new ArrayList<IMasterRepositoryProvider>();
        RepositoryFactory.registerServices();
    }

    private static void registerServices() {
        try {
            BundleContext context = RepositoryActivator.getContext();
            RepositoryFactory.registerRepositoryProviders(context);
            RepositoryFactory.registerMasterRepositoryProviders(context);
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void registerRepositoryProviders(BundleContext context) throws InvalidSyntaxException {
        IRepositoryProvider repositoryProvider;
        logger.info("Registering Repository Providers...");
        String defaultRepositoryProvider = System.getProperty("repositoryProvider");
        String localRepositoryProviderClass = "org.eclipse.dirigible.repository.local.LocalRepositoryProvider";
        Collection serviceReferences = context.getServiceReferences(IRepositoryProvider.class, null);
        for (ServiceReference serviceReference : serviceReferences) {
            repositoryProvider = (IRepositoryProvider)context.getService(serviceReference);
            repositoryProviders.add(repositoryProvider);
            logger.info(String.format("%s added to the list of available Repository Providers", repositoryProvider.getClass().getCanonicalName()));
            if (defaultRepositoryProvider != null) {
                if (!repositoryProvider.getClass().getCanonicalName().equals(defaultRepositoryProvider)) continue;
                logger.info(String.format("Repository Provider %s, set as Local Repository Provider", repositoryProvider.getClass().getCanonicalName()));
                localRepositoryProvider = repositoryProvider;
                continue;
            }
            if (!repositoryProvider.getClass().getCanonicalName().equals(localRepositoryProviderClass)) continue;
            logger.info("Standard Local Repository Provider is used");
            localRepositoryProvider = repositoryProvider;
        }
        if (localRepositoryProvider == null) {
            for (Object object : repositoryProviders) {
                repositoryProvider = (IRepositoryProvider)object;
                if (!repositoryProvider.getClass().getCanonicalName().equals(localRepositoryProviderClass)) continue;
                logger.info("Fallback to standard Local Repository Provider is used");
                localRepositoryProvider = repositoryProvider;
            }
        }
    }

    private static void registerMasterRepositoryProviders(BundleContext context) throws InvalidSyntaxException {
        logger.info("Registering Master Repository Providers...");
        String defaultMasterRepositoryProvider = System.getProperty("repositoryProviderMaster");
        Collection masterServiceReferences = context.getServiceReferences(IMasterRepositoryProvider.class, null);
        for (ServiceReference serviceReference : masterServiceReferences) {
            IMasterRepositoryProvider repositoryProvider = (IMasterRepositoryProvider)context.getService(serviceReference);
            masterRepositoryProviders.add(repositoryProvider);
            if (defaultMasterRepositoryProvider == null || !repositoryProvider.getClass().getCanonicalName().equals(defaultMasterRepositoryProvider)) continue;
            logger.info(String.format("Master Repository Provider %s, set as Master Repository Provider", repositoryProvider.getClass().getCanonicalName()));
            masterRepositoryProvider = repositoryProvider;
        }
    }

    public static IRepository createRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        if (localRepositoryProvider == null) {
            RepositoryFactory.registerServices();
            if (localRepositoryProvider == null) {
                if (repositoryProviders.size() == 0) {
                    throw new RepositoryCreationException("Local Repository Provider has NOT been registered");
                }
                localRepositoryProvider = repositoryProviders.get(0);
            }
        }
        IRepository repository = localRepositoryProvider.createRepository(parameters);
        return repository;
    }

    public static IMasterRepository createMasterRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        if (masterRepositoryProvider == null) {
            RepositoryFactory.registerServices();
            if (masterRepositoryProvider == null && masterRepositoryProviders.size() == 0) {
                logger.info("Master Repository Provider has NOT been registered");
                return null;
            }
        }
        if (masterRepositoryProvider == null) {
            return null;
        }
        IMasterRepository masterRepository = masterRepositoryProvider.createRepository(parameters);
        return masterRepository;
    }
}

