/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.workspace.ui.commands.OpenHandler;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public abstract class TemplateWizard
extends Wizard {
    private static final String GENERATION_FAILED = Messages.TemplateWizard_GENERATION_FAILED;
    private static final Logger logger = Logger.getLogger(TemplateWizard.class);

    protected abstract GenerationModel getModel();

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == null || !currentPage.isPageComplete()) {
            return false;
        }
        if (this.getModel().validate().hasErrors()) {
            return false;
        }
        return this.followingPagesAreComplete(currentPage);
    }

    private boolean followingPagesAreComplete(IWizardPage page) {
        IWizardPage currentPage = page.getNextPage();
        while (currentPage != null) {
            if (!currentPage.isPageComplete()) {
                return false;
            }
            currentPage = currentPage.getNextPage();
        }
        return true;
    }

    public boolean performFinish() {
        try {
            TemplateGenerator generator = this.getTemplateGenerator();
            generator.generate();
            this.openFiles(generator.getGeneratedFiles());
            return true;
        }
        catch (Exception ex) {
            logger.error(GENERATION_FAILED, (Throwable)ex);
            MessageDialog.openError(null, (String)GENERATION_FAILED, (String)ex.getMessage());
            return false;
        }
    }

    private void openFiles(List<IFile> generatedFiles) {
        if (generatedFiles.size() > 0) {
            if (generatedFiles.size() > 1) {
                if (this.openEditorForFileWithExtension() != null) {
                    for (IFile iFile : generatedFiles) {
                        if (!iFile.getName().endsWith(this.openEditorForFileWithExtension())) continue;
                        OpenHandler.open((Object)iFile, (int)0);
                    }
                }
            } else {
                OpenHandler.open((Object)generatedFiles.get(0), (int)0);
            }
        }
    }

    protected String openEditorForFileWithExtension() {
        return null;
    }

    public abstract TemplateGenerator getTemplateGenerator();
}

