/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository;

import java.util.HashMap;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryFactory;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;

public class RepositoryFacade {
    private static final String REPOSITORY = "repository-instance";
    private static RepositoryFacade instance;

    public static RepositoryFacade getInstance() {
        if (instance == null) {
            instance = new RepositoryFacade();
        }
        return instance;
    }

    public IRepository getRepository() throws RepositoryException {
        HttpServletRequest request = CommonParameters.getRequest();
        IRepository repository = this.getRepositoryInstance(request);
        if (repository != null) {
            return repository;
        }
        try {
            DataSource dataSource = this.lookupDataSource();
            String user = this.getUser(request);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("datasource", dataSource);
            parameters.put("user", user);
            parameters.put("recreate", Boolean.FALSE);
            repository = RepositoryFactory.createRepository(parameters);
            this.saveRepositoryInstance(request, repository);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        return repository;
    }

    public DataSource lookupDataSource() throws NamingException {
        return DataSourceFacade.getInstance().getDataSource(CommonParameters.getRequest());
    }

    public String getUser(HttpServletRequest request) {
        String user = CommonParameters.getUserName();
        try {
            if (request != null) {
                user = RequestUtils.getUser((HttpServletRequest)request);
            }
        }
        catch (Exception exception) {}
        return user;
    }

    private IRepository getRepositoryInstance(HttpServletRequest request) {
        return (IRepository)CommonParameters.getObject((String)REPOSITORY);
    }

    public void saveRepositoryInstance(HttpServletRequest request, IRepository repository) {
        if (request == null) {
            return;
        }
        CommonParameters.setObject((String)REPOSITORY, (Object)repository);
    }
}

