/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.repository.ext.fs.FileSystemUtils;
import org.eclipse.dirigible.repository.local.FileSystemRepository;

public class LocalWorkspaceMapper {
    private static final String DB_DIRIGIBLE_USERS_LOCAL_WORKSPACE = "/db/dirigible/users/local/workspace/";
    private static Map<String, String> prefixMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> prefixMapEquals = Collections.synchronizedMap(new HashMap());
    private static String workspaceRoot = "/";

    public static String getMappedName(FileSystemRepository repository, String repositoryName) throws IOException {
        String workspaceName = null;
        if (repositoryName != null && !"".equals(repositoryName) && FileSystemUtils.exists((String)repositoryName) && !"/".equals(repositoryName)) {
            return repositoryName;
        }
        if (workspaceName == null) {
            workspaceName = repositoryName.startsWith(repository.getRepositoryPath()) ? repositoryName : String.valueOf(repository.getRepositoryPath()) + repositoryName;
        }
        workspaceName = workspaceName.replace("/", File.separator);
        return workspaceName;
    }

    public static String getReverseMappedName(String workspaceName) {
        if (workspaceName == null || "".endsWith(workspaceName)) {
            return workspaceName;
        }
        if (workspaceName.startsWith(DB_DIRIGIBLE_USERS_LOCAL_WORKSPACE)) {
            return workspaceName;
        }
        workspaceName = workspaceName.substring(workspaceRoot.length());
        workspaceName = workspaceName.replace(File.separator, "/");
        return workspaceName;
    }
}

