/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalCollection;
import org.eclipse.dirigible.repository.local.LocalRepositoryDAO;
import org.eclipse.dirigible.repository.local.LocalResource;
import org.eclipse.dirigible.repository.local.LocalWorkspaceMapper;
import org.eclipse.dirigible.repository.local.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.zip.ZipExporter;
import org.eclipse.dirigible.repository.zip.ZipImporter;

public class FileSystemRepository
implements IRepository {
    public static final String PATH_SEGMENT_ROOT = "root";
    public static final String PATH_SEGMENT_VERSIONS = "versions";
    public static final String PATH_SEGMENT_INFO = "info";
    private static final String PROVIDED_ZIP_DATA_CANNOT_BE_NULL = Messages.getString("DBRepository.PROVIDED_ZIP_DATA_CANNOT_BE_NULL");
    private static final String PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL = Messages.getString("DBRepository.PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL");
    private static Logger logger = Logger.getLogger(FileSystemRepository.class);
    public static final String PATH_DELIMITER = "/";
    private String repositoryPath = "/";
    private String versionsPath = "/";
    private String infoPath = "/";
    private LocalRepositoryDAO repositoryDAO;
    private String user;

    public FileSystemRepository(String user) throws LocalBaseException {
        this(user, null);
    }

    public FileSystemRepository(String user, String rootFolder) throws LocalBaseException {
        String root = System.getProperty("user.dir");
        if (rootFolder != null) {
            root = String.valueOf(root) + File.separator;
            root = String.valueOf(root) + rootFolder;
        }
        this.user = user;
        this.repositoryDAO = new LocalRepositoryDAO(this);
        this.initializeRepository(root);
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getVersionsPath() {
        return this.versionsPath;
    }

    public String getInfoPath() {
        return this.infoPath;
    }

    protected String getRepositoryRootFolder() {
        return "dirigible_local";
    }

    private void initializeRepository(String rootFolder) {
        this.repositoryPath = String.valueOf(rootFolder) + PATH_DELIMITER + this.getRepositoryRootFolder() + PATH_DELIMITER + PATH_SEGMENT_ROOT;
        this.repositoryPath = this.repositoryPath.replace(PATH_DELIMITER, File.separator);
        this.versionsPath = String.valueOf(rootFolder) + PATH_DELIMITER + this.getRepositoryRootFolder() + PATH_DELIMITER + PATH_SEGMENT_VERSIONS;
        this.versionsPath = this.versionsPath.replace(PATH_DELIMITER, File.separator);
        this.infoPath = String.valueOf(rootFolder) + PATH_DELIMITER + this.getRepositoryRootFolder() + PATH_DELIMITER + PATH_SEGMENT_INFO;
        this.infoPath = this.infoPath.replace(PATH_DELIMITER, File.separator);
    }

    public ICollection getRoot() {
        logger.debug("entering getRoot");
        RepositoryPath wrapperPath = new RepositoryPath(PATH_DELIMITER);
        LocalCollection dbCollection = new LocalCollection(this, wrapperPath);
        logger.debug("exiting getRoot");
        return dbCollection;
    }

    public ICollection createCollection(String path) throws IOException {
        logger.debug("entering createCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalCollection collection = new LocalCollection(this, wrapperPath);
        collection.create();
        logger.debug("exiting createCollection");
        return collection;
    }

    public ICollection getCollection(String path) {
        logger.debug("entering getCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalCollection localCollection = new LocalCollection(this, wrapperPath);
        logger.debug("exiting getCollection");
        return localCollection;
    }

    public void removeCollection(String path) throws IOException {
        logger.debug("entering removeCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalCollection collection = new LocalCollection(this, wrapperPath);
        collection.delete();
        logger.debug("exiting removeCollection");
    }

    public boolean hasCollection(String path) throws IOException {
        logger.debug("entering hasCollection");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalCollection collection = new LocalCollection(this, wrapperPath);
        boolean result = collection.exists();
        logger.debug("exiting hasCollection");
        return result;
    }

    public IResource createResource(String path) throws IOException {
        logger.debug("entering createResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalResource resource = new LocalResource(this, wrapperPath);
        resource.create();
        logger.debug("exiting createResource");
        return resource;
    }

    public IResource createResource(String path, byte[] content) throws IOException {
        logger.debug("entering createResource with Content");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalResource resource = new LocalResource(this, wrapperPath);
        resource.setContent(content);
        logger.debug("exiting createResource with Content");
        return resource;
    }

    public IResource createResource(String path, byte[] content, boolean isBinary, String contentType) throws IOException {
        return this.createResource(path, content, isBinary, contentType, false);
    }

    public IResource createResource(String path, byte[] content, boolean isBinary, String contentType, boolean override) throws IOException {
        logger.debug("entering createResource with Content");
        try {
            this.getRepositoryDAO().createFile(path, content, isBinary, contentType);
        }
        catch (LocalBaseException e) {
            throw new IOException((Throwable)((Object)e));
        }
        IResource resource = this.getResource(path);
        logger.debug("exiting createResource with Content");
        return resource;
    }

    public IResource getResource(String path) {
        logger.debug("entering getResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalResource resource = new LocalResource(this, wrapperPath);
        logger.debug("exiting getResource");
        return resource;
    }

    public void removeResource(String path) throws IOException {
        logger.debug("entering removeResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalResource resource = new LocalResource(this, wrapperPath);
        resource.delete();
        logger.debug("exiting removeResource");
    }

    public boolean hasResource(String path) throws IOException {
        logger.debug("entering hasResource");
        RepositoryPath wrapperPath = new RepositoryPath(path);
        LocalResource resource = new LocalResource(this, wrapperPath);
        boolean result = resource.exists();
        logger.debug("exiting hasResource");
        return result;
    }

    public void dispose() {
    }

    public LocalRepositoryDAO getRepositoryDAO() {
        return this.repositoryDAO;
    }

    public void importZip(ZipInputStream zipInputStream, String path) throws IOException {
        this.importZip(zipInputStream, path, false);
    }

    public void importZip(ZipInputStream zipInputStream, String path, boolean override) throws IOException {
        this.importZip(zipInputStream, path, override, false);
    }

    public void importZip(ZipInputStream zipInputStream, String relativeRoot, boolean override, boolean excludeRootFolderName) throws IOException {
        if (zipInputStream == null) {
            logger.error(PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL);
            throw new IOException(PROVIDED_ZIP_INPUT_STREAM_CANNOT_BE_NULL);
        }
        ZipImporter.importZip((IRepository)this, (ZipInputStream)zipInputStream, (String)relativeRoot, (boolean)override, (boolean)excludeRootFolderName);
    }

    public void importZip(byte[] data, String path) throws IOException {
        this.importZip(data, path, false);
    }

    public void importZip(byte[] data, String path, boolean override) throws IOException {
        this.importZip(data, path, override, false, null);
    }

    public void importZip(byte[] data, String relativeRoot, boolean override, boolean excludeRootFolderName, Map<String, String> filter) throws IOException {
        if (data == null) {
            logger.error(PROVIDED_ZIP_DATA_CANNOT_BE_NULL);
            throw new IOException(PROVIDED_ZIP_DATA_CANNOT_BE_NULL);
        }
        ZipImporter.importZip((IRepository)this, (ZipInputStream)new ZipInputStream(new ByteArrayInputStream(data)), (String)relativeRoot, (boolean)override, (boolean)excludeRootFolderName, filter);
    }

    public byte[] exportZip(List<String> relativeRoots) throws IOException {
        return ZipExporter.exportZip((IRepository)this, relativeRoots);
    }

    public byte[] exportZip(String relativeRoot, boolean inclusive) throws IOException {
        return ZipExporter.exportZip((IRepository)this, (String)relativeRoot, (boolean)inclusive);
    }

    public List<IEntity> searchName(String parameter, boolean caseInsensitive) throws IOException {
        return null;
    }

    public List<IEntity> searchName(String root, String parameter, boolean caseInsensitive) throws IOException {
        String workspacePath = LocalWorkspaceMapper.getMappedName(this, root);
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (parameter == null || "".equals(parameter)) {
            return entities;
        }
        if (parameter.startsWith("%")) {
            parameter = parameter.substring(1);
        }
        File dir = new File(workspacePath);
        this.findInDirectory(dir, parameter, entities);
        return entities;
    }

    private void findInDirectory(File dir, String parameter, List<IEntity> entities) throws IOException {
        File[] all;
        File[] found;
        final String search = parameter;
        File[] fileArray = found = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(search);
            }
        });
        int n = found.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String repositoryName = f.getCanonicalPath().substring(this.getRepositoryPath().length());
            RepositoryPath repositoryPath = new RepositoryPath(repositoryName);
            entities.add(new LocalResource(this, repositoryPath));
            ++n2;
        }
        File[] fileArray2 = all = dir.listFiles();
        int n3 = all.length;
        n = 0;
        while (n < n3) {
            File f = fileArray2[n];
            if (f.isDirectory()) {
                this.findInDirectory(f, parameter, entities);
            }
            ++n;
        }
    }

    public List<IEntity> searchPath(String parameter, boolean caseInsensitive) throws IOException {
        return null;
    }

    public List<IEntity> searchText(String parameter, boolean caseInsensitive) throws IOException {
        return null;
    }

    public List<IResourceVersion> getResourceVersions(String path) throws IOException {
        return this.repositoryDAO.getResourceVersionsByPath(path);
    }

    public IResourceVersion getResourceVersion(String path, int version) throws IOException {
        return null;
    }

    public void cleanupOldVersions() throws IOException {
    }

    public String getUser() {
        return this.user;
    }
}

