/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.ui.internal.branding.AbstractBranding;
import org.eclipse.rap.ui.internal.branding.Branding;
import org.eclipse.rap.ui.internal.branding.BrandingManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrandingExtension {
    private static final String EP_BRANDING = "org.eclipse.rap.ui.branding";
    private static final String ATT_ID = "id";
    private static final String ATT_THEME_ID = "themeId";
    private static final String ATT_FAVICON = "favicon";
    private static final String ATT_TITLE = "title";
    private static final String ATT_BODY = "body";
    private static final String ELEM_ADITIONAL_HEADERS = "additionalHeaders";
    private static final String TAG_META = "meta";
    private static final String TAG_LINK = "link";
    private static final String ELEM_ATTRIBUTE = "attribute";
    private static final String ATT_NAME = "name";
    private static final String ATT_CONTENT = "content";
    private static final String ATT_REL = "rel";
    private static final String ATT_HREF = "href";
    private static final String ATT_VALUE = "value";
    private static final String ELEM_SERVICE_SELECTOR = "httpServiceFilter";
    private static final String ATT_CLASS = "class";
    private final Application application;
    private final ServiceReference<HttpService> httpServiceReference;

    public BrandingExtension(Application configuration, ServiceReference<HttpService> httpServiceReference) {
        this.application = configuration;
        this.httpServiceReference = httpServiceReference;
    }

    public void read() throws IOException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EP_BRANDING);
        IConfigurationElement[] brandings = ep.getConfigurationElements();
        int i = 0;
        while (i < brandings.length) {
            IConfigurationElement configElement = brandings[i];
            this.readBranding(configElement);
            ++i;
        }
    }

    private void readBranding(IConfigurationElement element) throws IOException {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ATT_ID);
        String body = element.getAttribute(ATT_BODY);
        String title = element.getAttribute(ATT_TITLE);
        String favIcon = element.getAttribute(ATT_FAVICON);
        String themeId = element.getAttribute(ATT_THEME_ID);
        Branding branding = new Branding(contributor);
        branding.setId(id);
        branding.setBody(this.readBody(contributor, body));
        branding.setTitle(title);
        branding.setThemeId(themeId);
        branding.setFavIcon(favIcon);
        IConfigurationElement[] additionalHeaders = element.getChildren(ELEM_ADITIONAL_HEADERS);
        if (additionalHeaders.length > 0) {
            IConfigurationElement additionalHeader = additionalHeaders[0];
            this.readAdditionalHeader(branding, additionalHeader);
        }
        if (!this.isFiltered(element)) {
            this.register(branding);
            this.registerFavIcon(element, favIcon);
        }
    }

    private boolean isFiltered(IConfigurationElement element) {
        boolean result = false;
        if (this.httpServiceReference != null) {
            Filter serviceFilter = this.readServiceFilter(element);
            result = serviceFilter != null && !serviceFilter.match(this.httpServiceReference);
        }
        return result;
    }

    private Filter readServiceFilter(IConfigurationElement element) {
        IConfigurationElement serviceFilterElement;
        String filterClass;
        Filter result = null;
        IConfigurationElement[] serviceFilterElements = element.getChildren(ELEM_SERVICE_SELECTOR);
        if (serviceFilterElements.length > 0 && (filterClass = (serviceFilterElement = serviceFilterElements[0]).getAttribute(ATT_CLASS)) != null) {
            try {
                result = (Filter)serviceFilterElement.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException exception) {
                String message = "Could not instantiate http service filter for branding: " + filterClass;
                throw new IllegalArgumentException(message, exception);
            }
        }
        return result;
    }

    private void register(AbstractBranding branding) {
        BrandingManager.getInstance().register(branding);
    }

    private void registerFavIcon(IConfigurationElement element, final String favIcon) {
        if (favIcon != null) {
            final Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            this.application.addResource(favIcon, new ResourceLoader(){

                public InputStream getResourceAsStream(String resourceName) throws IOException {
                    return FileLocator.openStream((Bundle)bundle, (IPath)new Path(favIcon), (boolean)false);
                }
            });
        }
    }

    private void readAdditionalHeader(Branding branding, IConfigurationElement elem) {
        IConfigurationElement[] headers = elem.getChildren();
        int i = 0;
        while (i < headers.length) {
            IConfigurationElement header = headers[i];
            HashMap<String, String> attributes = new HashMap<String, String>();
            String tagName = header.getName();
            if (TAG_META.equals(tagName)) {
                attributes.put(ATT_NAME, header.getAttribute(ATT_NAME));
                attributes.put(ATT_CONTENT, header.getAttribute(ATT_CONTENT));
            } else if (TAG_LINK.equals(tagName)) {
                attributes.put(ATT_REL, header.getAttribute(ATT_REL));
                attributes.put(ATT_HREF, header.getAttribute(ATT_HREF));
            }
            IConfigurationElement[] addAttrs = header.getChildren(ELEM_ATTRIBUTE);
            int k = 0;
            while (k < addAttrs.length) {
                String name = addAttrs[k].getAttribute(ATT_NAME);
                String value = addAttrs[k].getAttribute(ATT_VALUE);
                attributes.put(name, value);
                ++k;
            }
            branding.addHeader(tagName, attributes);
            ++i;
        }
    }

    private String readBody(String contributor, String path) throws IOException {
        URL url;
        InputStream inputStream;
        String result = null;
        if (path != null && (inputStream = (url = Platform.getBundle((String)contributor).getResource(path)).openStream()) != null) {
            try {
                StringBuffer buffer = new StringBuffer();
                byte[] bytes = new byte[512];
                int bytesRead = inputStream.read(bytes);
                while (bytesRead != -1) {
                    buffer.append(new String(bytes, 0, bytesRead));
                    bytesRead = inputStream.read(bytes);
                }
                result = buffer.toString();
            }
            finally {
                inputStream.close();
            }
        }
        return result;
    }
}

