/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterFactory;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetLifeCycleAdapter;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.events.EventList;
import org.eclipse.swt.internal.events.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.IdGenerator;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.internal.widgets.WidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Widget
implements Adaptable,
SerializableCompatibility {
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int DISPOSED = 1;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int SKIN_NEEDED = 0x200000;
    int style;
    int state;
    Display display;
    private Object data;
    private EventTable eventTable;
    private transient LifeCycleAdapterFactory lifeCycleAdapterFactory;
    private WidgetAdapter widgetAdapter;
    private IWidgetGraphicsAdapter widgetGraphicsAdapter;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        if (parent == null) {
            SWT.error(4);
        }
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
        WidgetAdapterImpl adapter = (WidgetAdapterImpl)this.getAdapter(WidgetAdapter.class);
        adapter.setParent(parent);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result = null;
        if (adapter == WidgetAdapter.class) {
            if (this.widgetAdapter == null) {
                String id = IdGenerator.getInstance().createId(this);
                this.widgetAdapter = new WidgetAdapterImpl(id);
            }
            result = this.widgetAdapter;
        } else if (adapter == IThemeAdapter.class) {
            ApplicationContextImpl applicationContext = this.getApplicationContext();
            ThemeManager themeManager = applicationContext.getThemeManager();
            result = themeManager.getThemeAdapterManager().getThemeAdapter(this);
        } else if (adapter == IWidgetGraphicsAdapter.class) {
            if (this.widgetGraphicsAdapter == null) {
                this.widgetGraphicsAdapter = new WidgetGraphicsAdapter();
            }
            result = this.widgetGraphicsAdapter;
        } else if (adapter == WidgetLifeCycleAdapter.class) {
            if (this.lifeCycleAdapterFactory == null) {
                this.lifeCycleAdapterFactory = this.getApplicationContext().getLifeCycleAdapterFactory();
            }
            result = this.lifeCycleAdapterFactory.getAdapter(this);
        }
        return (T)result;
    }

    private ApplicationContextImpl getApplicationContext() {
        IDisplayAdapter displayAdapter = this.display.getAdapter(IDisplayAdapter.class);
        return (ApplicationContextImpl)displayAdapter.getUISession().getApplicationContext();
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        Object result = null;
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (result == null && i < table.length) {
                if (key.equals(table[i])) {
                    result = table[i + 1];
                }
                i += 2;
            }
        }
        return result;
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        this.handleCustomId(key, value);
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    private void handleCustomId(String key, Object value) {
        if (key.equals("org.eclipse.rap.rwt.customWidgetId") && value instanceof String) {
            WidgetAdapterImpl adapter = (WidgetAdapterImpl)this.getAdapter(WidgetAdapter.class);
            adapter.setCustomId((String)value);
        }
    }

    public Display getDisplay() {
        if ((this.state & 1) != 0) {
            this.error(24);
        }
        return this.display;
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable != null) {
            this.eventTable.unhook(12, listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.ensureEventTable();
        this.eventTable.hook(eventType, listener);
        if (listener instanceof ClientListener) {
            ClientListenerUtil.clientListenerAdded(this, eventType, (ClientListener)listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable != null) {
            this.eventTable.unhook(eventType, listener);
        }
        if (listener instanceof ClientListener) {
            ClientListenerUtil.clientListenerRemoved(this, eventType, (ClientListener)listener);
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        Event newEvent = event == null ? new Event() : event;
        newEvent.widget = this;
        newEvent.type = eventType;
        newEvent.display = this.display;
        if (newEvent.time == 0) {
            newEvent.time = EventUtil.getLastEventTime();
        }
        this.sendEvent(newEvent);
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.eventTable == null ? false : this.eventTable.hooks(eventType);
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        Listener[] result = this.eventTable == null ? new Listener[]{} : this.eventTable.getListeners(eventType);
        return result;
    }

    protected void removeListener(int eventType, SWTEventListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable != null) {
            this.eventTable.unhook(eventType, listener);
        }
    }

    private void sendEvent(Event event) {
        if (Widget.isEventProcessingPhase()) {
            event.display.filterEvent(event);
            if (this.eventTable != null) {
                this.eventTable.sendEvent(event);
            }
        } else {
            EventList.getInstance().add(event);
        }
    }

    private static boolean isEventProcessingPhase() {
        PhaseId currentPhase = CurrentPhase.get();
        return PhaseId.PREPARE_UI_ROOT.equals(currentPhase) || PhaseId.PROCESS_ACTION.equals(currentPhase);
    }

    private void ensureEventTable() {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x200000) != 0x200000) {
            this.state |= 0x200000;
            this.display.addSkinnableWidget(this);
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index != -1) {
            string = string.substring(index + 1, string.length());
        }
        return string;
    }

    String getNameText() {
        return "";
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (!this.isValidThread()) {
                this.error(22);
            }
            if ((this.state & 0x1000) == 0) {
                this.state |= 0x1000;
                this.notifyListeners(12, new Event());
            }
            if ((this.state & 1) == 0) {
                this.releaseChildren();
            }
            if ((this.state & 0x800) == 0) {
                this.state |= 0x800;
                this.releaseParent();
                this.releaseWidget();
                WidgetAdapter adapter = this.getAdapter(WidgetAdapter.class);
                adapter.markDisposed(this);
            }
        }
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isInDispose() {
        return (this.state & 0x1000) != 0;
    }

    void releaseChildren() {
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.lifeCycleAdapterFactory = null;
        this.eventTable = null;
        this.state |= 1;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    protected void checkWidget() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int result = style;
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((result & mask) == 0) {
            result |= int0;
        }
        if ((result & int0) != 0) {
            result = result & ~mask | int0;
        }
        if ((result & int1) != 0) {
            result = result & ~mask | int1;
        }
        if ((result & int2) != 0) {
            result = result & ~mask | int2;
        }
        if ((result & int3) != 0) {
            result = result & ~mask | int3;
        }
        if ((result & int4) != 0) {
            result = result & ~mask | int4;
        }
        if ((result & int5) != 0) {
            result = result & ~mask | int5;
        }
        return result;
    }

    void checkOrientation(Widget parent) {
        if ((this.style & 0x2000000) == 0 && parent != null && (parent.style & 0x2000000) != 0) {
            this.style |= 0x2000000;
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0, 0, 0, 0, 0);
    }

    void error(int code) {
        SWT.error(code);
    }
}

