/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.RawRule;
import org.eclipse.tm4e.core.internal.rule.BeginEndRule;
import org.eclipse.tm4e.core.internal.rule.BeginWhileRule;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.IRuleFactoryHelper;
import org.eclipse.tm4e.core.internal.rule.IncludeOnlyRule;
import org.eclipse.tm4e.core.internal.rule.MatchRule;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.types.IRawCaptures;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class RuleFactory {
    private static final System.Logger LOGGER = System.getLogger(RuleFactory.class.getName());

    private static CaptureRule createCaptureRule(IRuleFactoryHelper helper, @Nullable String name, @Nullable String contentName, @Nullable Integer retokenizeCapturedWithRuleId) {
        return helper.registerRule(id -> new CaptureRule(id, name, contentName, retokenizeCapturedWithRuleId));
    }

    public static int getCompiledRuleId(IRawRule desc, IRuleFactoryHelper helper, IRawRepository repository) {
        if (desc.getId() == null) {
            helper.registerRule(ruleId -> {
                desc.setId(ruleId);
                String ruleMatch = desc.getMatch();
                if (ruleMatch != null) {
                    return new MatchRule(ruleId, desc.getName(), ruleMatch, RuleFactory.compileCaptures(desc.getCaptures(), helper, repository));
                }
                String begin = desc.getBegin();
                if (begin == null) {
                    IRawRepository repository1 = desc.getRepository() == null ? repository : IRawRepository.merge(repository, desc.getRepository());
                    Collection<IRawRule> patterns = desc.getPatterns();
                    if (patterns == null && desc.getInclude() != null) {
                        RawRule includeRule = new RawRule();
                        includeRule.setInclude(desc.getInclude());
                        patterns = List.of(includeRule);
                    }
                    return new IncludeOnlyRule(ruleId, desc.getName(), desc.getContentName(), RuleFactory.compilePatterns(patterns, helper, repository1));
                }
                String ruleWhile = desc.getWhile();
                if (ruleWhile != null) {
                    return new BeginWhileRule(ruleId, desc.getName(), desc.getContentName(), begin, RuleFactory.compileCaptures(desc.getBeginCaptures() != null ? desc.getBeginCaptures() : desc.getCaptures(), helper, repository), ruleWhile, RuleFactory.compileCaptures(desc.getWhileCaptures() != null ? desc.getWhileCaptures() : desc.getCaptures(), helper, repository), RuleFactory.compilePatterns(desc.getPatterns(), helper, repository));
                }
                return new BeginEndRule(ruleId, desc.getName(), desc.getContentName(), begin, RuleFactory.compileCaptures(desc.getBeginCaptures() != null ? desc.getBeginCaptures() : desc.getCaptures(), helper, repository), desc.getEnd(), RuleFactory.compileCaptures(desc.getEndCaptures() != null ? desc.getEndCaptures() : desc.getCaptures(), helper, repository), desc.isApplyEndPatternLast(), RuleFactory.compilePatterns(desc.getPatterns(), helper, repository));
            });
        }
        return NullSafetyHelper.castNonNull(desc.getId());
    }

    private static List<@Nullable CaptureRule> compileCaptures(@Nullable IRawCaptures captures, IRuleFactoryHelper helper, IRawRepository repository) {
        if (captures == null) {
            return Collections.emptyList();
        }
        int maximumCaptureId = 0;
        for (String captureId : captures.getCaptureIds()) {
            int numericCaptureId = RuleFactory.parseInt(captureId, 10);
            if (numericCaptureId <= maximumCaptureId) continue;
            maximumCaptureId = numericCaptureId;
        }
        ArrayList<CaptureRule> r = new ArrayList<CaptureRule>();
        int i = 0;
        while (i <= maximumCaptureId) {
            r.add(null);
            ++i;
        }
        for (String captureId : captures.getCaptureIds()) {
            int numericCaptureId = RuleFactory.parseInt(captureId, 10);
            IRawRule rule = captures.getCapture(captureId);
            Integer retokenizeCapturedWithRuleId = rule.getPatterns() == null ? null : Integer.valueOf(RuleFactory.getCompiledRuleId(captures.getCapture(captureId), helper, repository));
            r.set(numericCaptureId, RuleFactory.createCaptureRule(helper, rule.getName(), rule.getContentName(), retokenizeCapturedWithRuleId));
        }
        return r;
    }

    private static int parseInt(String string, int base) {
        try {
            return Integer.parseInt(string, base);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private static CompilePatternsResult compilePatterns(@Nullable Collection<IRawRule> patterns, IRuleFactoryHelper helper, IRawRepository repository) {
        if (patterns == null) {
            return new CompilePatternsResult(new int[0], false);
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (IRawRule pattern : patterns) {
            Rule rule;
            int patternId;
            block34: {
                patternId = -1;
                String patternInclude = pattern.getInclude();
                if (patternInclude == null) {
                    patternId = RuleFactory.getCompiledRuleId(pattern, helper, repository);
                } else if (patternInclude.charAt(0) == '#') {
                    IRawRule localIncludedRule = repository.getRule(patternInclude.substring(1));
                    if (localIncludedRule != null) {
                        patternId = RuleFactory.getCompiledRuleId(localIncludedRule, helper, repository);
                    } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        LOGGER.log(System.Logger.Level.DEBUG, "CANNOT find rule for scopeName: %s, I am: %s", patternInclude, repository.getBase().getName());
                    }
                } else if (patternInclude.equals("$base")) {
                    patternId = RuleFactory.getCompiledRuleId(repository.getBase(), helper, repository);
                } else if (patternInclude.equals("$self")) {
                    patternId = RuleFactory.getCompiledRuleId(repository.getSelf(), helper, repository);
                } else {
                    String externalGrammarInclude;
                    String externalGrammarName;
                    int sharpIndex = patternInclude.indexOf(35);
                    if (sharpIndex >= 0) {
                        externalGrammarName = patternInclude.substring(0, sharpIndex);
                        externalGrammarInclude = patternInclude.substring(sharpIndex + 1);
                    } else {
                        externalGrammarName = patternInclude;
                        externalGrammarInclude = null;
                    }
                    IRawGrammar externalGrammar = helper.getExternalGrammar(externalGrammarName, repository);
                    if (externalGrammar != null) {
                        IRawRepository externalGrammarRepo = externalGrammar.getRepository();
                        if (externalGrammarInclude != null) {
                            IRawRule externalIncludedRule = externalGrammarRepo.getRule(externalGrammarInclude);
                            if (externalIncludedRule != null) {
                                patternId = RuleFactory.getCompiledRuleId(externalIncludedRule, helper, externalGrammarRepo);
                            } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                                LOGGER.log(System.Logger.Level.DEBUG, "CANNOT find rule for scopeName: %s, I am: %s", patternInclude, repository.getBase().getName());
                            }
                        } else {
                            patternId = RuleFactory.getCompiledRuleId(externalGrammarRepo.getSelf(), helper, externalGrammarRepo);
                        }
                    } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        LOGGER.log(System.Logger.Level.DEBUG, "CANNOT find grammar for scopeName: %s, I am: %s", patternInclude, repository.getBase().getName());
                    }
                }
                if (patternId == -1) continue;
                try {
                    rule = helper.getRule(patternId);
                }
                catch (IndexOutOfBoundsException ex) {
                    rule = null;
                    if (patternInclude != null) break block34;
                    ex.printStackTrace();
                }
            }
            boolean skipRule = false;
            if (rule instanceof IncludeOnlyRule) {
                IncludeOnlyRule ior = (IncludeOnlyRule)rule;
                if (ior.hasMissingPatterns && ior.patterns.length == 0) {
                    skipRule = true;
                }
            } else if (rule instanceof BeginEndRule) {
                BeginEndRule ber = (BeginEndRule)rule;
                if (ber.hasMissingPatterns && ber.patterns.length == 0) {
                    skipRule = true;
                }
            } else if (rule instanceof BeginWhileRule) {
                BeginWhileRule bwr = (BeginWhileRule)rule;
                if (bwr.hasMissingPatterns && bwr.patterns.length == 0) {
                    skipRule = true;
                }
            }
            if (skipRule) {
                LOGGER.log(System.Logger.Level.DEBUG, "REMOVING RULE ENTIRELY DUE TO EMPTY PATTERNS THAT ARE MISSING");
                continue;
            }
            r.add(patternId);
        }
        return new CompilePatternsResult(r.stream().mapToInt(Integer::intValue).toArray(), patterns.size() != r.size());
    }

    private RuleFactory() {
    }
}

