/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.snippet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.snippet.Snippet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension9;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.osgi.framework.Bundle;

public class SnippetContentAssistProcessor
implements IContentAssistProcessor {
    private static final String SINGLE_LINE_COMMENT = "(?s).*(\\/\\/[^\\n]*)";
    private static final String MULTI_LINE_COMMENT = "(?s).*\\/\\*(.(?!\\*\\/))*";
    private static final String ENDS_WITH_WORD = "(?<indent>\\s*).*?(?<prefix>\\w*)";
    private static final Pattern ENDS_WITH_WORD_PATTERN = Pattern.compile("(?<indent>\\s*).*?(?<prefix>\\w*)");
    private static final Pattern SINGLE_LINE_COMMENT_PATTERN = Pattern.compile("(?s).*(\\/\\/[^\\n]*)");
    private static final Pattern MULTI_LINE_COMMENT_PATTERN = Pattern.compile("(?s).*\\/\\*(.(?!\\*\\/))*");
    private static final List<Snippet> snippets = new ArrayList<Snippet>();

    static {
        JsonArray snippetArray = null;
        try {
            URL url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)CorrosionPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)"snippets/rust.json"), Collections.emptyMap()));
            StringBuilder snippetsBuilder = new StringBuilder();
            Files.readAllLines(new File(url.getFile()).toPath()).forEach(snippetsBuilder::append);
            snippetArray = JsonParser.parseString((String)snippetsBuilder.toString()).getAsJsonArray();
        }
        catch (IOException url) {
            // empty catch block
        }
        if (snippetArray != null) {
            for (JsonElement jsonElement : snippetArray) {
                JsonObject snippet = jsonElement.getAsJsonObject();
                String name = snippet.get("display").getAsString();
                int completionItemKind = snippet.get("completionItemKind").getAsInt();
                JsonArray replacementLines = snippet.get("replacementLines").getAsJsonArray();
                String[] lines = new String[replacementLines.size()];
                int i = 0;
                while (i < replacementLines.size()) {
                    lines[i] = replacementLines.get(i).getAsString();
                    ++i;
                }
                SnippetContentAssistProcessor.addSnippet(new Snippet(name, CompletionItemKind.forValue((int)completionItemKind), lines));
            }
        }
    }

    private static void addSnippet(Snippet snippet) {
        snippets.add(snippet);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        String textToOffset = document.get().substring(0, offset);
        if (SnippetContentAssistProcessor.isOffsetInComment(textToOffset)) {
            return new ICompletionProposal[0];
        }
        Matcher matcher = ENDS_WITH_WORD_PATTERN.matcher(textToOffset.substring(textToOffset.lastIndexOf(10) + 1));
        matcher.matches();
        String indent = matcher.group("indent");
        String prefix = matcher.group("prefix");
        Range range = SnippetContentAssistProcessor.getRangeFromSelection(document, viewer).orElseGet(() -> {
            try {
                int line = document.getLineOfOffset(offset);
                int lineOffset = offset - document.getLineOffset(line);
                Position start = new Position(line, lineOffset - prefix.length());
                Position end = new Position(line, lineOffset);
                return new Range(start, end);
            }
            catch (BadLocationException e) {
                return null;
            }
        });
        if (range == null) {
            return new ICompletionProposal[0];
        }
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)document, capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider().get()));
        LanguageServiceAccessor.LSPDocumentInfo docInfo = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
        return (ICompletionProposal[])snippets.stream().filter(s -> s.matchesPrefix(prefix)).map(s -> s.convertToCompletionProposal(offset, docInfo, indent, range)).toArray(ICompletionProposal[]::new);
    }

    private static Optional<Range> getRangeFromSelection(IDocument document, ITextViewer viewer) {
        if (!(viewer instanceof ITextViewerExtension9)) {
            return Optional.empty();
        }
        ITextViewerExtension9 textViewer = (ITextViewerExtension9)viewer;
        ITextSelection textSelection = textViewer.getLastKnownSelection();
        if (textSelection == null) {
            return Optional.empty();
        }
        int selectionLength = textSelection.getLength();
        if (selectionLength <= 0) {
            return Optional.empty();
        }
        try {
            int startOffset = textSelection.getOffset();
            Position startPosition = LSPEclipseUtils.toPosition((int)startOffset, (IDocument)document);
            int endOffset = startOffset + selectionLength;
            Position endPosition = LSPEclipseUtils.toPosition((int)endOffset, (IDocument)document);
            return Optional.of(new Range(startPosition, endPosition));
        }
        catch (BadLocationException e) {
            return Optional.empty();
        }
    }

    private static boolean isOffsetInComment(String textToOffset) {
        Matcher singleLineCommentMatcher = SINGLE_LINE_COMMENT_PATTERN.matcher(textToOffset);
        Matcher multiLineCommentMatcher = MULTI_LINE_COMMENT_PATTERN.matcher(textToOffset);
        return singleLineCommentMatcher.matches() || multiLineCommentMatcher.matches();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

