/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class ErrorLineMatcher
implements IPatternMatchListenerDelegate {
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            FileLocation entry = FileLocation.readFromConsoleString(this.console.getDocument().get(event.getOffset(), event.getLength()));
            this.console.addHyperlink(ErrorLineMatcher.makeHyperlink(ErrorLineMatcher.getProject(this.console), entry), offset, length);
        }
        catch (CoreException | BadLocationException e) {
            CorrosionPlugin.logError(e);
        }
    }

    private static IHyperlink makeHyperlink(final IProject project, final FileLocation location) {
        return new IHyperlink(){

            public void linkExited() {
            }

            public void linkEntered() {
            }

            public void linkActivated() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = null;
                Optional<IFile> ifile = this.toIFile(project, location.filePath);
                try {
                    if (ifile.isPresent()) {
                        editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)ifile.get());
                    } else {
                        File file = new File(location.filePath);
                        if (file.isFile()) {
                            IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)EFS.getStore((URI)file.getAbsoluteFile().toURI()));
                        }
                    }
                    if (editorPart != null) {
                        ErrorLineMatcher.jumpToPosition(editorPart, location.lineNumber, location.lineOffset);
                    }
                }
                catch (CoreException ex) {
                    CorrosionPlugin.logError(ex);
                }
            }

            private Optional<IFile> toIFile(IProject project2, String filePath) {
                IFile file2;
                if (filePath == null) {
                    return Optional.empty();
                }
                if (project2 != null && project2.isAccessible() && (file2 = project2.getFile(Path.fromOSString((String)filePath))).isAccessible()) {
                    return Optional.of(file2);
                }
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(filePath).getAbsoluteFile().toURI());
                return Arrays.stream(files).filter(IResource::isAccessible).min(Comparator.comparingInt(file -> file.getProjectRelativePath().segmentCount()));
            }
        };
    }

    private static void jumpToPosition(IEditorPart editorPart, int lineNumber, int lineOffset) {
        ITextEditor textEditor;
        IDocument document;
        if (editorPart instanceof ITextEditor && (document = (textEditor = (ITextEditor)editorPart).getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            IRegion region = null;
            try {
                region = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (region != null) {
                textEditor.selectAndReveal(region.getOffset() + lineOffset - 1, 0);
            }
        }
    }

    private static IProject getProject(TextConsole console) throws CoreException {
        String projectName;
        IProcess process = (IProcess)console.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        if (process == null) {
            return null;
        }
        ILaunch launch = process.getLaunch();
        String projectAttribute = "org.eclipse.cdt.launch.PROJECT_ATTR";
        String launchConfigurationType = launch.getLaunchConfiguration().getType().getIdentifier();
        if (launchConfigurationType.equals("org.eclipse.corrosion.debug.RustDebugDelegate")) {
            projectAttribute = "org.eclipse.cdt.launch.PROJECT_ATTR";
        }
        if ((projectName = launch.getLaunchConfiguration().getAttribute(projectAttribute, "")).trim().isEmpty()) {
            return null;
        }
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject myProject = myWorkspaceRoot.getProject(projectName);
        return myProject.isAccessible() ? myProject : null;
    }

    private static class FileLocation {
        public final String filePath;
        public final int lineNumber;
        public final int lineOffset;

        private FileLocation(String filePath, int lineNumber, int lineOffset) {
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.lineOffset = lineOffset;
        }

        public static FileLocation readFromConsoleString(String consoleString) {
            int lineNumberLineOffsetSeparatorIndex = consoleString.lastIndexOf(58);
            int fileNameLineNumberSeparatorIndex = consoleString.lastIndexOf(58, lineNumberLineOffsetSeparatorIndex - 1);
            return new FileLocation(consoleString.substring(0, fileNameLineNumberSeparatorIndex), Integer.parseInt(consoleString.substring(fileNameLineNumberSeparatorIndex + 1, lineNumberLineOffsetSeparatorIndex)), Integer.parseInt(consoleString.substring(lineNumberLineOffsetSeparatorIndex + 1)));
        }
    }
}

