/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferenceInitializer;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.corrosion.ui.InputComponent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class CorrosionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.corrosion.preferencePage";
    private IPreferenceStore store;
    private Combo rustupToolchainCombo;
    private InputComponent rlsInput;
    private InputComponent sysrootInput;
    private InputComponent rlsConfigurationPathInput;
    private Button installButton;
    private InputComponent rustupInput;
    private InputComponent cargoInput;
    private InputComponent workingDirectoryInput;
    private boolean installInProgress = false;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.rustupInput = new InputComponent(container, Messages.CorrosionPreferencePage_Rustup, e -> this.setValid(this.isPageValid()));
        this.rustupInput.createComponent();
        this.rustupInput.createVariableSelection();
        this.rustupInput.createFileSelection();
        Label rustupToolchainLabel = new Label(container, 0);
        rustupToolchainLabel.setText(Messages.CorrosionPreferencePage_toolchain);
        GridData rustupToolchainGridData = new GridData(131072, 0x1000000, false, false);
        rustupToolchainLabel.setLayoutData((Object)rustupToolchainGridData);
        Composite toolchainParent = new Composite(container, 0);
        toolchainParent.setLayout((Layout)new GridLayout(2, false));
        toolchainParent.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.rustupToolchainCombo = new Combo(toolchainParent, 4);
        this.rustupToolchainCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.rustupToolchainCombo.add("stable");
        this.rustupToolchainCombo.add("beta");
        this.rustupToolchainCombo.add("nightly");
        this.rustupToolchainCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setValid(this.isPageValid())));
        this.rustupToolchainCombo.addModifyListener(e -> this.setValid(this.isPageValid()));
        this.cargoInput = new InputComponent(container, Messages.CorrosionPreferencePage_caro, e -> this.setValid(this.isPageValid()));
        this.cargoInput.createComponent();
        this.cargoInput.createVariableSelection();
        this.cargoInput.createFileSelection();
        this.sysrootInput = new InputComponent(container, Messages.CorrosionPreferencePage_sysrootPath, e -> this.setValid(this.isPageValid()));
        this.sysrootInput.createComponent();
        this.sysrootInput.createVariableSelection();
        this.sysrootInput.createFileSelection();
        new Composite(container, 0).setLayoutData((Object)new GridData(0, 0));
        this.installButton = new Button(container, 8);
        this.installButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.installButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (Platform.getOS().equals("win32")) {
                Program.launch((String)"https://rustup.rs/");
            } else {
                this.installRustupCommands();
            }
        }));
        this.workingDirectoryInput = new InputComponent(container, Messages.LaunchUI_workingDirectory, e -> this.setValid(this.isPageValid()));
        this.workingDirectoryInput.createComponent();
        this.workingDirectoryInput.createVariableSelection();
        this.workingDirectoryInput.createFolderSelection();
        new Composite(container, 0).setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
        this.rlsInput = new InputComponent(container, Messages.CorrosionPreferencePage_rlsPath, e -> this.setValid(this.isPageValid()));
        this.rlsInput.createComponent();
        this.rlsInput.createVariableSelection();
        this.rlsInput.createFileSelection();
        new Composite(container, 0).setLayoutData((Object)new GridData(0, 0));
        Button dlAndInstallRustAnalyzerButton = new Button(container, 8);
        dlAndInstallRustAnalyzerButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        dlAndInstallRustAnalyzerButton.setText(Messages.CorrosionPreferencePage_downloadRustAnalyzer);
        dlAndInstallRustAnalyzerButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            dlAndInstallRustAnalyzerButton.setEnabled(false);
            dlAndInstallRustAnalyzerButton.setText(Messages.CorrosionPreferencePage_downloadingRustAnalyzer);
            dlAndInstallRustAnalyzerButton.getParent().layout(new Control[]{dlAndInstallRustAnalyzerButton});
            this.rlsInput.setEnabled(false);
            ((CompletableFuture)RustManager.downloadAndInstallRustAnalyzer(progress -> dlAndInstallRustAnalyzerButton.getDisplay().asyncExec(() -> {
                dlAndInstallRustAnalyzerButton.setText(NLS.bind((String)Messages.CorrosionPreferencePage_downloadingRustAnalyzer, (Object)((int)(100.0 * progress))));
                dlAndInstallRustAnalyzerButton.requestLayout();
            })).thenAccept(file -> {
                if (!dlAndInstallRustAnalyzerButton.isDisposed()) {
                    dlAndInstallRustAnalyzerButton.getDisplay().asyncExec(() -> {
                        this.rlsInput.setValue(file.getAbsolutePath());
                        this.rlsInput.setEnabled(true);
                        dlAndInstallRustAnalyzerButton.setText(Messages.CorrosionPreferencePage_downloadRustAnalyzer);
                        this.setValid(this.isPageValid());
                    });
                }
            })).exceptionally(ex -> {
                dlAndInstallRustAnalyzerButton.getDisplay().asyncExec(() -> {
                    dlAndInstallRustAnalyzerButton.setText("\ud83d\uded1" + ex.getMessage());
                    dlAndInstallRustAnalyzerButton.getParent().requestLayout();
                });
                return null;
            });
        }));
        this.rlsConfigurationPathInput = new InputComponent(container, Messages.CorrosionPreferencePage_rlsConfigurationPath, e -> this.setValid(this.isPageValid()));
        this.rlsConfigurationPathInput.createComponent();
        this.rlsConfigurationPathInput.createVariableSelection();
        this.rlsConfigurationPathInput.createFileSelection();
        this.initializeContent();
        return container;
    }

    private void initializeContent() {
        String toolchainId = this.store.getString("corrosion.rustup_toolchain_Id");
        this.rustupToolchainCombo.setText(toolchainId);
        this.rustupInput.setValue(this.store.getString("corrosion.rustup_rustupPath"));
        this.cargoInput.setValue(this.store.getString("corrosion.rustup_cargoPath"));
        this.rlsInput.setValue(this.store.getString("corrosion.rslPath"));
        this.sysrootInput.setValue(this.store.getString("corrosion.sysrootPath"));
        this.workingDirectoryInput.setValue(this.store.getString("corrosion.workingDirectory"));
        this.rlsConfigurationPathInput.setValue(this.store.getString("corrosion.rls_configurationPath"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CorrosionPlugin.getDefault().getPreferenceStore();
    }

    private boolean isPageValid() {
        this.setMessage(null);
        return this.isCommandPathsValid() && this.isRustupSectionValid() && this.isLanguageServerInstallSectionValid();
    }

    private boolean isCommandPathsValid() {
        String error = "";
        if (this.cargoInput.getValue().isEmpty()) {
            error = Messages.CorrosionPreferencePage_emptyRustupCargoPath;
        } else if (this.rustupInput.getValue().isEmpty()) {
            this.setMessage(Messages.CorrosionPreferencePage_emptyRustupCargoPath, 2);
        } else {
            File rustup = new File(CorrosionPreferencePage.varParse(this.rustupInput.getValue()));
            File cargo = new File(CorrosionPreferencePage.varParse(this.cargoInput.getValue()));
            if (!rustup.exists() || !rustup.isFile()) {
                error = Messages.CorrosionPreferencePage_invalidRustup;
            } else if (!rustup.canExecute()) {
                error = Messages.CorrosionPreferencePage_rustupNonExecutable;
            } else if (!CorrosionPlugin.validateCommandVersion(CorrosionPreferencePage.varParse(this.rustupInput.getValue()), RustManager.RUSTUP_VERSION_FORMAT_PATTERN)) {
                error = NLS.bind((String)Messages.CorrosionPreferencePage_invalidVersion, (Object)"rustup");
            } else if (!cargo.exists() || !cargo.isFile()) {
                error = Messages.CorrosionPreferencePage_invalidCargo;
            } else if (!cargo.canExecute()) {
                error = Messages.CorrosionPreferencePage_cargoNonExecutable;
            } else if (!CorrosionPlugin.validateCommandVersion(CorrosionPreferencePage.varParse(this.cargoInput.getValue()), RustManager.CARGO_VERSION_FORMAT_PATTERN)) {
                error = NLS.bind((String)Messages.CorrosionPreferencePage_invalidVersion, (Object)"cargo");
            }
        }
        if (!error.isEmpty()) {
            this.setErrorMessage(error);
            this.setInstallRequired(true);
            return false;
        }
        File workingDirectory = new File(CorrosionPreferencePage.varParse(this.workingDirectoryInput.getValue()));
        if (this.workingDirectoryInput.getValue().isEmpty()) {
            error = Messages.CorrosionPreferencePage_emptyWorkingDirectory;
        } else if (!workingDirectory.isDirectory() || !workingDirectory.exists()) {
            error = Messages.CorrosionPreferencePage_invaildWorkingDirectory;
        }
        if (!error.isEmpty()) {
            this.setErrorMessage(error);
        }
        return error.isEmpty();
    }

    private boolean isRustupSectionValid() {
        if (this.rustupToolchainCombo.getText().isBlank()) {
            this.setMessage(Messages.CorrosionPreferencePage_emptyToolchain);
        }
        return true;
    }

    private boolean isLanguageServerInstallSectionValid() {
        if (this.rlsInput.getValue().isEmpty() || this.sysrootInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_emptyPath);
            return false;
        }
        File rls = new File(CorrosionPreferencePage.varParse(this.rlsInput.getValue()));
        if (!rls.exists() || !rls.isFile()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_invalidRlsPath);
            return false;
        }
        if (!rls.canExecute()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_rlsNonExecutable);
            return false;
        }
        File sysrootPath = new File(CorrosionPreferencePage.varParse(this.sysrootInput.getValue()));
        boolean a = sysrootPath.exists();
        boolean b = sysrootPath.isDirectory();
        if (!a || !b) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_invalidSysroot);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private static String varParse(String unparsedString) {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return manager.performStringSubstitution(unparsedString);
        }
        catch (CoreException e) {
            return unparsedString;
        }
    }

    protected void performDefaults() {
        String toolchainId = this.store.getDefaultString("corrosion.rustup_toolchain_Id");
        this.rustupToolchainCombo.setText(toolchainId);
        this.rustupInput.setValue(this.store.getDefaultString("corrosion.rustup_rustupPath"));
        this.cargoInput.setValue(this.store.getDefaultString("corrosion.rustup_cargoPath"));
        this.rlsInput.setValue(this.store.getDefaultString("corrosion.rslPath"));
        this.sysrootInput.setValue(this.store.getDefaultString("corrosion.sysrootPath"));
        this.workingDirectoryInput.setValue(this.store.getDefaultString("corrosion.workingDirectory"));
        super.performDefaults();
    }

    public boolean performOk() {
        this.store.setValue("corrosion.workingDirectory", this.workingDirectoryInput.getValue());
        this.store.setValue("corrosion.rls_configurationPath", this.rlsConfigurationPathInput.getValue());
        this.store.setValue("corrosion.rustup_rustupPath", this.rustupInput.getValue());
        this.store.setValue("corrosion.rustup_cargoPath", this.cargoInput.getValue());
        String id = this.rustupToolchainCombo.getText();
        if (!this.store.getString("corrosion.rustup_toolchain_Id").equals(id)) {
            RustManager.setDefaultToolchain(id);
            this.store.setValue("corrosion.rustup_toolchain_Id", id);
        }
        this.store.setValue("corrosion.rslPath", this.rlsInput.getValue());
        this.store.setValue("corrosion.sysrootPath", this.sysrootInput.getValue());
        return true;
    }

    private void installRustupCommands() {
        String[] command;
        this.installButton.setText(Messages.CorrosionPreferencePage_installing);
        this.installButton.setEnabled(false);
        this.setMessage(Messages.CorrosionPreferencePage_installingRustupCargo);
        try {
            Bundle bundle = CorrosionPlugin.getDefault().getBundle();
            URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry("scripts/rustup-init.sh"));
            File file = new File(new URI(fileURL.getProtocol(), fileURL.getPath(), null));
            if (!file.setExecutable(true)) {
                CorrosionPlugin.showError(Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details);
                return;
            }
            command = new String[]{file.getAbsolutePath(), "-y"};
        }
        catch (IOException | URISyntaxException e) {
            CorrosionPlugin.showError(Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details, e);
            return;
        }
        CommandJob installCommandJob = new CommandJob(command, Messages.CorrosionPreferencePage_installingRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details, 15);
        final String toolchain = this.rustupToolchainCombo.getText();
        installCommandJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.OK_STATUS) {
                    CorrosionPreferenceInitializer initializer = new CorrosionPreferenceInitializer();
                    initializer.initializeDefaultPreferences();
                    Job setDefaultToolchainJob = RustManager.setDefaultToolchain(toolchain.isEmpty() ? "stable" : toolchain);
                    setDefaultToolchainJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            (this).CorrosionPreferencePage.this.installInProgress = false;
                            Display.getDefault().asyncExec(() -> {
                                if ((this).CorrosionPreferencePage.this.installButton.isDisposed()) {
                                    return;
                                }
                                CorrosionPreferencePage.this.setInstallRequired(false);
                                CorrosionPreferencePage.this.performDefaults();
                                CorrosionPreferencePage.this.setValid(CorrosionPreferencePage.this.isPageValid());
                            });
                        }
                    });
                } else {
                    CorrosionPreferencePage.this.installInProgress = false;
                }
            }
        });
        this.installInProgress = true;
        installCommandJob.schedule();
    }

    private void setInstallRequired(boolean required) {
        if (this.installInProgress) {
            return;
        }
        if (required) {
            this.installButton.setText(Messages.CorrosionPreferencePage_install);
        } else {
            this.installButton.setText(Messages.CorrosionPreferencePage_installed);
        }
        this.installButton.setEnabled(required);
    }
}

