/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.ApiQuickFixProcessor;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class JavadocConversionRefactoring
extends Refactoring {
    static Map<String, String> ALL_API_IMPORTS = new HashMap<String, String>();
    private HashSet<IProject> projects = new HashSet();
    private boolean removeTags = true;

    static {
        ALL_API_IMPORTS.put("NoExtend", "org.eclipse.pde.api.tools.annotations.NoExtend");
        ALL_API_IMPORTS.put("NoImplement", "org.eclipse.pde.api.tools.annotations.NoImplement");
        ALL_API_IMPORTS.put("NoInstantiate", "org.eclipse.pde.api.tools.annotations.NoInstantiate");
        ALL_API_IMPORTS.put("NoOverride", "org.eclipse.pde.api.tools.annotations.NoOverride");
        ALL_API_IMPORTS.put("NoReference", "org.eclipse.pde.api.tools.annotations.NoReference");
    }

    public void setRemoveTags(boolean remove) {
        this.removeTags = remove;
    }

    public void setProjects(Set<IProject> newProjects) {
        this.projects.clear();
        if (newProjects != null) {
            this.projects.addAll(newProjects);
        }
    }

    public String getName() {
        return WizardMessages.JavadocConversionRefactoring_convert_tag_to_annotation_refactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)WizardMessages.JavadocConversionPage_scanning_projects_for_javadoc_tags, (int)(this.projects.size() * 100));
        CompositeChange change = new CompositeChange(WizardMessages.JavadocTagRefactoring_1);
        IProject project = null;
        CompositeChange pchange = null;
        Iterator<IProject> iterator = this.projects.iterator();
        while (iterator.hasNext()) {
            if (localmonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            project = iterator.next();
            localmonitor.setTaskName(NLS.bind((String)WizardMessages.JavadocConversionPage_scan_javadoc_to_convert, (Object[])new Object[]{project.getName()}));
            pchange = new CompositeChange(project.getName());
            IFile build = project.getFile("build.properties");
            Change createBuildPropertiesChange = null;
            if (ApiQuickFixProcessor.needsBuildPropertiesChange(build)) {
                try {
                    createBuildPropertiesChange = ApiQuickFixProcessor.createBuildPropertiesChange(build);
                    pchange.add(createBuildPropertiesChange);
                }
                catch (CoreException coreException) {}
            }
            try {
                this.createChanges(pchange, JavaCore.create((IProject)project), this.removeTags, localmonitor.split(100));
            }
            catch (CoreException e) {
                ApiUIPlugin.log(e);
            }
            if (localmonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (pchange.getChildren().length == 1 && createBuildPropertiesChange != null && createBuildPropertiesChange.equals(pchange.getChildren()[0]) || pchange.getChildren().length <= 0) continue;
            change.add((Change)pchange);
        }
        return change;
    }

    RefactoringStatus createChanges(CompositeChange projectchange, IJavaProject project, boolean remove, SubMonitor monitor) throws CoreException {
        HashMap<IFile, Set<TextEdit>> map = new HashMap<IFile, Set<TextEdit>>();
        RefactoringStatus status = this.collectAnnotationEdits(project, map, remove, (IProgressMonitor)monitor.split(75));
        if (status.isOK()) {
            IFile file = null;
            TextFileChange change = null;
            MultiTextEdit multiedit = null;
            Set<TextEdit> alledits = null;
            for (Map.Entry<IFile, Set<TextEdit>> entry : map.entrySet()) {
                if (monitor.isCanceled()) {
                    return status;
                }
                file = entry.getKey();
                monitor.setTaskName(NLS.bind((String)WizardMessages.JavadocConversionPage_collect_edits, (Object[])new Object[]{file.getName()}));
                change = new TextFileChange(MessageFormat.format(WizardMessages.JavadocConversionPage_convert_javadoc_tags_in, file.getName()), file);
                multiedit = new MultiTextEdit();
                change.setEdit((TextEdit)multiedit);
                alledits = entry.getValue();
                if (alledits != null) {
                    for (TextEdit edit : alledits) {
                        multiedit.addChild(edit);
                    }
                }
                projectchange.add((Change)change);
            }
        }
        monitor.setWorkRemaining(0);
        return status;
    }

    RefactoringStatus collectAnnotationEdits(IJavaProject project, Map<IFile, Set<TextEdit>> collector, boolean remove, IProgressMonitor monitor) throws CoreException {
        IApiComponent component;
        RefactoringStatus status = new RefactoringStatus();
        IApiBaseline baseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        if (baseline != null && (component = baseline.getApiComponent(project.getProject())) != null) {
            IApiDescription description = component.getApiDescription();
            AnnotVisitor visitor = new AnnotVisitor(project, component, description, remove, monitor);
            description.accept((ApiDescriptionVisitor)visitor, null);
            collector.putAll(visitor.changes);
        }
        return status;
    }

    class AnnotVisitor
    extends ApiDescriptionVisitor {
        Map<IFile, Set<TextEdit>> changes = new HashMap<IFile, Set<TextEdit>>();
        boolean remove = false;
        IJavaProject project = null;
        IApiComponent component = null;
        IApiDescription apidescription = null;
        SubMonitor monitor = null;

        public AnnotVisitor(IJavaProject project, IApiComponent component, IApiDescription description, boolean remove, IProgressMonitor monitor) {
            this.project = project;
            this.component = component;
            this.apidescription = description;
            this.remove = remove;
            this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        }

        public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
            if (element.getElementType() == 2) {
                try {
                    IType type = this.project.findType(((IReferenceTypeDescriptor)element).getQualifiedName(), (IProgressMonitor)new NullProgressMonitor());
                    if (type != null) {
                        this.collectUpdates(type, element, this.apidescription);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    return false;
                }
                catch (CoreException e) {
                    ApiUIPlugin.log(e);
                }
                return false;
            }
            return super.visitElement(element, description);
        }

        void collectUpdates(IType type, IElementDescriptor element, IApiDescription description) throws CoreException {
            ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
            ICompilationUnit cunit = type.getCompilationUnit();
            if (cunit != null) {
                if (this.monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.monitor.worked(1);
                this.monitor.setTaskName(NLS.bind((String)WizardMessages.JavadocConversionPage_scan_javadoc_to_convert, (Object[])new Object[]{type.getFullyQualifiedName()}));
                parser.setSource(cunit);
                parser.setResolveBindings(true);
                Map options = cunit.getJavaProject().getOptions(true);
                options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                parser.setCompilerOptions(options);
                CompilationUnit cast = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                cast.recordModifications();
                ASTRewrite rewrite = ASTRewrite.create((AST)cast.getAST());
                TagVisitor visitor = new TagVisitor(this.component, description, rewrite, this.remove);
                cast.accept((ASTVisitor)visitor);
                ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
                IPath path = cast.getJavaElement().getPath();
                try {
                    bm.connect(path, LocationKind.IFILE, null);
                    ITextFileBuffer tfb = bm.getTextFileBuffer(path, LocationKind.IFILE);
                    IDocument document = tfb.getDocument();
                    TextEdit edit = rewrite.rewriteAST(document, null);
                    if (edit.getChildrenSize() > 0 || edit.getLength() != 0) {
                        IFile file = (IFile)cunit.getUnderlyingResource();
                        Set<TextEdit> edits = this.changes.get(file);
                        if (edits == null) {
                            edits = new HashSet<TextEdit>(3);
                            this.changes.put(file, edits);
                        }
                        edits.add(edit);
                    }
                }
                finally {
                    bm.disconnect(path, LocationKind.IFILE, null);
                }
            }
        }
    }

    class TagVisitor
    extends ASTVisitor {
        IApiComponent component = null;
        IApiDescription apidescription = null;
        ASTRewrite rewrite = null;
        boolean remove = false;
        List<String> existingImports = new ArrayList<String>();
        List<String> missingImports = new ArrayList<String>();

        public TagVisitor(IApiComponent component, IApiDescription description, ASTRewrite rewrite, boolean remove) {
            this.component = component;
            this.apidescription = description;
            this.rewrite = rewrite;
            this.remove = remove;
        }

        public void endVisit(CompilationUnit node) {
            ListRewrite lrewrite;
            if (this.missingImports.size() > 0 && (lrewrite = this.getListrewrite((ASTNode)node)) != null) {
                for (String missing : this.missingImports) {
                    ImportDeclaration imp = node.getAST().newImportDeclaration();
                    imp.setName(node.getAST().newName(missing));
                    lrewrite.insertLast((ASTNode)imp, null);
                }
            }
            this.missingImports.clear();
            this.existingImports.clear();
            super.endVisit(node);
        }

        public boolean visit(ImportDeclaration node) {
            String name = node.getName().getFullyQualifiedName();
            if (!ALL_API_IMPORTS.containsValue(name)) {
                this.existingImports.add(name);
            }
            return super.visit(node);
        }

        public boolean visit(TypeDeclaration node) {
            IReferenceTypeDescriptor desc;
            IApiAnnotations annots;
            ITypeBinding binding = node.resolveBinding();
            if (binding != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.typeDescriptor((String)binding.getQualifiedName())))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            IReferenceTypeDescriptor desc;
            IApiAnnotations annots;
            ITypeBinding binding = node.resolveBinding();
            if (binding != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.typeDescriptor((String)binding.getQualifiedName())))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            IReferenceTypeDescriptor desc;
            IApiAnnotations annots;
            ITypeBinding binding = node.resolveBinding();
            if (binding != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.typeDescriptor((String)binding.getQualifiedName())))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            ASTNode parent = node.getParent();
            ITypeBinding binding = null;
            if (parent instanceof AbstractTypeDeclaration) {
                binding = ((AbstractTypeDeclaration)parent).resolveBinding();
            } else if (parent instanceof AnnotationTypeDeclaration) {
                binding = ((AnnotationTypeDeclaration)parent).resolveBinding();
            }
            if (binding != null) {
                List fragments = node.fragments();
                IFieldDescriptor desc = Factory.fieldDescriptor((String)binding.getQualifiedName(), (String)((VariableDeclarationFragment)fragments.get(0)).getName().getIdentifier());
                IApiAnnotations annots = this.apidescription.resolveAnnotations((IElementDescriptor)desc);
                if (annots != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                    this.updateNode((BodyDeclaration)node, annots);
                }
            }
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            ASTNode parent = node.getParent();
            ITypeBinding binding = null;
            if (parent instanceof AbstractTypeDeclaration) {
                binding = ((AbstractTypeDeclaration)parent).resolveBinding();
            } else if (parent instanceof AnnotationTypeDeclaration) {
                binding = ((AnnotationTypeDeclaration)parent).resolveBinding();
            }
            if (binding != null) {
                IMethodDescriptor method = Factory.methodDescriptor((String)binding.getQualifiedName(), (String)node.getName().getIdentifier(), (String)Signatures.getMethodSignatureFromNode((MethodDeclaration)node, (boolean)true));
                try {
                    method = Factory.resolveMethod((IApiTypeContainer)this.component, (IMethodDescriptor)method);
                    IApiAnnotations annots = this.apidescription.resolveAnnotations((IElementDescriptor)method);
                    if (annots != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                        this.updateNode((BodyDeclaration)node, annots);
                    }
                }
                catch (CoreException coreException) {}
            }
            return true;
        }

        void updateNode(BodyDeclaration body, IApiAnnotations annotations) {
            Javadoc docnode;
            ListRewrite lrewrite = this.getListrewrite((ASTNode)body);
            if (lrewrite != null) {
                MarkerAnnotation newannot;
                AST ast = body.getAST();
                ArrayList mods = body.modifiers();
                if (mods == null) {
                    mods = new ArrayList();
                    this.rewrite.set((ASTNode)body, (StructuralPropertyDescriptor)body.getModifiersProperty(), mods, null);
                }
                ArrayList<String> existing = new ArrayList<String>();
                for (IExtendedModifier modifier : mods) {
                    Annotation annot;
                    String name;
                    if (!modifier.isAnnotation() || !JavadocTagManager.ALL_ANNOTATIONS.contains(name = (annot = (Annotation)modifier).getTypeName().getFullyQualifiedName())) continue;
                    existing.add(name);
                }
                int restrictions = annotations.getRestrictions();
                if (RestrictionModifiers.isExtendRestriction((int)restrictions) && !existing.contains("NoExtend")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoExtend"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoExtend");
                }
                if (RestrictionModifiers.isImplementRestriction((int)restrictions) && !existing.contains("NoImplement")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoImplement"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoImplement");
                }
                if (RestrictionModifiers.isInstantiateRestriction((int)restrictions) && !existing.contains("NoInstantiate")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoInstantiate"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoInstantiate");
                }
                if (RestrictionModifiers.isOverrideRestriction((int)restrictions) && !existing.contains("NoOverride")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoOverride"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoOverride");
                }
                if (RestrictionModifiers.isReferenceRestriction((int)restrictions) && !existing.contains("NoReference")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoReference"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoReference");
                }
            }
            if (this.remove && (docnode = body.getJavadoc()) != null) {
                List tags = docnode.tags();
                lrewrite = this.rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
                for (TagElement tag : tags) {
                    if (!JavadocTagManager.ALL_TAGS.contains(tag.getTagName())) continue;
                    lrewrite.remove((ASTNode)tag, null);
                }
            }
        }

        void ensureImport(String added) {
            String annot = ALL_API_IMPORTS.get(added);
            if (annot != null && !this.existingImports.contains(annot)) {
                this.missingImports.add(annot);
            }
        }

        ListRewrite getListrewrite(ASTNode node) {
            switch (node.getNodeType()) {
                case 55: {
                    return this.rewrite.getListRewrite(node, TypeDeclaration.MODIFIERS2_PROPERTY);
                }
                case 81: {
                    return this.rewrite.getListRewrite(node, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
                }
                case 71: {
                    return this.rewrite.getListRewrite(node, EnumDeclaration.MODIFIERS2_PROPERTY);
                }
                case 23: {
                    return this.rewrite.getListRewrite(node, FieldDeclaration.MODIFIERS2_PROPERTY);
                }
                case 31: {
                    return this.rewrite.getListRewrite(node, MethodDeclaration.MODIFIERS2_PROPERTY);
                }
                case 15: {
                    return this.rewrite.getListRewrite(node, CompilationUnit.IMPORTS_PROPERTY);
                }
            }
            return null;
        }
    }
}

