/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class OEPlaceholderAtom
extends RecordAtom {
    public static final int PLACEHOLDER_FULLSIZE = 0;
    public static final int PLACEHOLDER_HALFSIZE = 1;
    public static final int PLACEHOLDER_QUARTSIZE = 2;
    private byte[] _header = new byte[8];
    private int placementId;
    private int placeholderId;
    private int placeholderSize;
    private short unusedShort;

    public OEPlaceholderAtom() {
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)this.getRecordType());
        LittleEndian.putInt(this._header, 4, 8);
        this.placementId = 0;
        this.placeholderId = 0;
        this.placeholderSize = 0;
    }

    protected OEPlaceholderAtom(byte[] source, int start, int len) {
        int offset = start;
        System.arraycopy(source, start, this._header, 0, 8);
        this.placementId = LittleEndian.getInt(source, offset += this._header.length);
        this.placeholderId = LittleEndian.getUByte(source, offset += 4);
        this.placeholderSize = LittleEndian.getUByte(source, ++offset);
        this.unusedShort = LittleEndian.getShort(source, ++offset);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.OEPlaceholderAtom.typeID;
    }

    public int getPlacementId() {
        return this.placementId;
    }

    public void setPlacementId(int id2) {
        this.placementId = id2;
    }

    public int getPlaceholderId() {
        return this.placeholderId;
    }

    public void setPlaceholderId(byte id2) {
        this.placeholderId = id2;
    }

    public int getPlaceholderSize() {
        return this.placeholderSize;
    }

    public void setPlaceholderSize(byte size) {
        this.placeholderSize = size;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        byte[] recdata = new byte[8];
        LittleEndian.putInt(recdata, 0, this.placementId);
        recdata[4] = (byte)this.placeholderId;
        recdata[5] = (byte)this.placeholderSize;
        LittleEndian.putShort(recdata, 6, this.unusedShort);
        out.write(recdata);
    }
}

