/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef.attribute;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hmef.attribute.TNEFDateAttribute;
import org.apache.poi.hmef.attribute.TNEFMAPIAttribute;
import org.apache.poi.hmef.attribute.TNEFProperty;
import org.apache.poi.hmef.attribute.TNEFStringAttribute;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public class TNEFAttribute {
    private static final int MAX_RECORD_LENGTH = 1000000;
    private final TNEFProperty property;
    private final int type;
    private final byte[] data;
    private final int checksum;

    protected TNEFAttribute(int id2, int type, InputStream inp) throws IOException {
        this.type = type;
        int length = LittleEndian.readInt(inp);
        this.property = TNEFProperty.getBest(id2, type);
        this.data = IOUtils.safelyAllocate(length, 1000000);
        IOUtils.readFully(inp, this.data);
        this.checksum = LittleEndian.readUShort(inp);
    }

    public static TNEFAttribute create(InputStream inp) throws IOException {
        int id2 = LittleEndian.readUShort(inp);
        int type = LittleEndian.readUShort(inp);
        if (id2 == TNEFProperty.ID_MAPIPROPERTIES.id || id2 == TNEFProperty.ID_ATTACHMENT.id) {
            return new TNEFMAPIAttribute(id2, type, inp);
        }
        if (type == 1 || type == 2) {
            return new TNEFStringAttribute(id2, type, inp);
        }
        if (type == 3) {
            return new TNEFDateAttribute(id2, type, inp);
        }
        return new TNEFAttribute(id2, type, inp);
    }

    public TNEFProperty getProperty() {
        return this.property;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "Attribute " + this.property + ", type=" + this.type + ", data length=" + this.data.length;
    }
}

