/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.poi.hemf.record.emf.HemfDraw;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecord;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecordIterator;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HemfComment {
    private static final int MAX_RECORD_LENGTH = 50000000;

    public static class EmfCommentDataUnicode
    implements EmfCommentData {
        private final Rectangle2D bounds = new Rectangle2D.Double();
        private final List<EmfCommentDataFormat> formats = new ArrayList<EmfCommentDataFormat>();

        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfUnicodeString;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            throw new RecordFormatException("UNICODE_STRING/UNICODE_END values are reserved in CommentPublic records");
        }
    }

    public static class EmfCommentDataWMF
    implements EmfCommentData {
        private final Rectangle2D bounds = new Rectangle2D.Double();
        private final List<EmfCommentDataFormat> formats = new ArrayList<EmfCommentDataFormat>();

        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfWMF;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            int startIdx = leis.getReadIndex();
            int commentIdentifier = (int)leis.readUInt();
            assert ((long)commentIdentifier == HemfCommentRecordType.emfPublic.id);
            int publicCommentIdentifier = (int)leis.readUInt();
            assert ((long)publicCommentIdentifier == HemfCommentRecordType.emfWMF.id);
            int version = leis.readUShort();
            leis.skipFully(2);
            int checksum = leis.readInt();
            int flags = leis.readInt();
            int winMetafileSize = (int)leis.readUInt();
            byte[] winMetafile = IOUtils.safelyAllocate(winMetafileSize, 50000000);
            leis.read(winMetafile);
            return leis.getReadIndex() - startIdx;
        }
    }

    public static class EmfCommentDataFormat {
        private EmfFormatSignature signature;
        private int version;
        private int sizeData;
        private int offData;
        private byte[] rawData;

        public long init(LittleEndianInputStream leis, long dataSize, long startIdx) throws IOException {
            this.signature = EmfFormatSignature.getById(leis.readInt());
            this.version = leis.readInt();
            this.sizeData = leis.readInt();
            this.offData = leis.readInt();
            if (this.sizeData < 0) {
                throw new RecordFormatException("size for emrformat must be > 0");
            }
            if (this.offData < 0) {
                throw new RecordFormatException("offset for emrformat must be > 0");
            }
            return 16L;
        }

        public byte[] getRawData() {
            return this.rawData;
        }

        static /* synthetic */ byte[] access$102(EmfCommentDataFormat x0, byte[] x1) {
            x0.rawData = x1;
            return x1;
        }
    }

    public static enum EmfFormatSignature {
        ENHMETA_SIGNATURE(1179469088),
        EPS_SIGNATURE(1179865157);

        int id;

        private EmfFormatSignature(int id2) {
            this.id = id2;
        }

        public static EmfFormatSignature getById(int id2) {
            for (EmfFormatSignature wrt : EmfFormatSignature.values()) {
                if (wrt.id != id2) continue;
                return wrt;
            }
            return null;
        }
    }

    public static class EmfCommentDataMultiformats
    implements EmfCommentData {
        private final Rectangle2D bounds = new Rectangle2D.Double();
        private final List<EmfCommentDataFormat> formats = new ArrayList<EmfCommentDataFormat>();

        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfMultiFormats;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            int startIdx = leis.getReadIndex();
            int commentIdentifier = (int)leis.readUInt();
            assert ((long)commentIdentifier == HemfCommentRecordType.emfPublic.id);
            int publicCommentIdentifier = (int)leis.readUInt();
            assert ((long)publicCommentIdentifier == HemfCommentRecordType.emfMultiFormats.id);
            HemfDraw.readRectL(leis, this.bounds);
            int countFormats = (int)leis.readUInt();
            for (int i = 0; i < countFormats; ++i) {
                EmfCommentDataFormat fmt = new EmfCommentDataFormat();
                long readBytes = fmt.init(leis, dataSize, startIdx);
                this.formats.add(fmt);
                if (readBytes == 0L) break;
            }
            for (EmfCommentDataFormat fmt : this.formats) {
                int skip = fmt.offData - (leis.getReadIndex() - startIdx);
                leis.skipFully(skip);
                EmfCommentDataFormat.access$102(fmt, IOUtils.safelyAllocate(fmt.sizeData, 50000000));
                int readBytes = leis.read(fmt.rawData);
                if (readBytes >= fmt.sizeData) continue;
                break;
            }
            return leis.getReadIndex() - startIdx;
        }

        public List<EmfCommentDataFormat> getFormats() {
            return Collections.unmodifiableList(this.formats);
        }
    }

    public static class EmfCommentDataEndGroup
    implements EmfCommentData {
        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfEndGroup;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            int startIdx = leis.getReadIndex();
            int commentIdentifier = (int)leis.readUInt();
            assert ((long)commentIdentifier == HemfCommentRecordType.emfPublic.id);
            int publicCommentIdentifier = (int)leis.readUInt();
            assert ((long)publicCommentIdentifier == HemfCommentRecordType.emfEndGroup.id);
            return leis.getReadIndex() - startIdx;
        }
    }

    public static class EmfCommentDataBeginGroup
    implements EmfCommentData {
        private final Rectangle2D bounds = new Rectangle2D.Double();
        private String description;

        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfBeginGroup;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            int startIdx = leis.getReadIndex();
            int commentIdentifier = (int)leis.readUInt();
            assert ((long)commentIdentifier == HemfCommentRecordType.emfPublic.id);
            int publicCommentIdentifier = (int)leis.readUInt();
            assert ((long)publicCommentIdentifier == HemfCommentRecordType.emfBeginGroup.id);
            HemfDraw.readRectL(leis, this.bounds);
            int nDescription = (int)leis.readUInt();
            byte[] buf = IOUtils.safelyAllocate(nDescription * 2, 50000000);
            leis.readFully(buf);
            this.description = new String(buf, StandardCharsets.UTF_16LE);
            return leis.getReadIndex() - startIdx;
        }
    }

    public static class EmfCommentDataPlus
    implements EmfCommentData {
        private final List<HemfPlusRecord> records = new ArrayList<HemfPlusRecord>();

        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfPlus;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            long startIdx = leis.getReadIndex();
            int commentIdentifier = leis.readInt();
            assert ((long)commentIdentifier == HemfCommentRecordType.emfPlus.id);
            new HemfPlusRecordIterator(leis, (int)dataSize - 4).forEachRemaining(this.records::add);
            return (long)leis.getReadIndex() - startIdx;
        }

        public List<HemfPlusRecord> getRecords() {
            return Collections.unmodifiableList(this.records);
        }
    }

    public static class EmfCommentDataGeneric
    implements EmfCommentData {
        private byte[] privateData;

        @Override
        public HemfCommentRecordType getCommentRecordType() {
            return HemfCommentRecordType.emfGeneric;
        }

        @Override
        public long init(LittleEndianInputStream leis, long dataSize) throws IOException {
            this.privateData = IOUtils.safelyAllocate(dataSize, 50000000);
            leis.readFully(this.privateData);
            return this.privateData.length;
        }

        public String toString() {
            return "\"" + new String(this.privateData, LocaleUtil.CHARSET_1252).replaceAll("\\p{Cntrl}", ".") + "\"";
        }
    }

    public static class EmfCommentDataIterator
    implements Iterator<EmfCommentData> {
        private final LittleEndianInputStream leis;
        private final int startIdx;
        private final int limit;
        private EmfCommentData currentRecord;
        private final boolean emfParent;

        public EmfCommentDataIterator(LittleEndianInputStream leis, int limit, boolean emfParent) {
            this.leis = leis;
            this.limit = limit;
            this.emfParent = emfParent;
            this.startIdx = leis.getReadIndex();
            this.currentRecord = this._next();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public EmfCommentData next() {
            EmfCommentData toReturn = this.currentRecord;
            boolean isEOF = this.limit == -1 || this.leis.getReadIndex() >= this.startIdx + this.limit;
            this.currentRecord = isEOF ? null : this._next();
            return toReturn;
        }

        private EmfCommentData _next() {
            long recordSize;
            if (this.currentRecord == null && this.emfParent) {
                long type = HemfRecordType.comment.id;
                recordSize = this.limit;
            } else {
                long type;
                try {
                    type = this.leis.readUInt();
                }
                catch (RuntimeException e) {
                    return null;
                }
                assert (type == HemfRecordType.comment.id);
                recordSize = this.leis.readUInt();
            }
            long dataSize = this.leis.readUInt();
            try {
                this.leis.mark(8);
                int commentIdentifier = (int)this.leis.readUInt();
                int publicCommentIdentifier = (int)this.leis.readUInt();
                boolean isEmfPublic = (long)commentIdentifier == HemfCommentRecordType.emfPublic.id;
                this.leis.reset();
                HemfCommentRecordType commentType = HemfCommentRecordType.getById(isEmfPublic ? (long)publicCommentIdentifier : (long)commentIdentifier, isEmfPublic);
                assert (commentType != null);
                EmfCommentData record = commentType.constructor.get();
                long readBytes = record.init(this.leis, dataSize);
                int skipBytes = (int)(recordSize - 4L - readBytes);
                assert (skipBytes >= 0);
                this.leis.skipFully(skipBytes);
                return record;
            }
            catch (IOException e) {
                throw new RecordFormatException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }

    public static class EmfComment
    implements HemfRecord {
        private EmfCommentData data;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.comment;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            int startIdx = leis.getReadIndex();
            this.data = new EmfCommentDataIterator(leis, (int)recordSize, true).next();
            return leis.getReadIndex() - startIdx;
        }

        public EmfCommentData getCommentData() {
            return this.data;
        }

        public String toString() {
            return "{ data: " + this.data + " }";
        }
    }

    public static interface EmfCommentData {
        public HemfCommentRecordType getCommentRecordType();

        public long init(LittleEndianInputStream var1, long var2) throws IOException;
    }

    public static enum HemfCommentRecordType {
        emfGeneric(-1L, EmfCommentDataGeneric::new, false),
        emfSpool(0L, EmfCommentDataGeneric::new, false),
        emfPlus(726027589L, EmfCommentDataPlus::new, false),
        emfPublic(1128875079L, null, false),
        emfBeginGroup(2L, EmfCommentDataBeginGroup::new, true),
        emfEndGroup(3L, EmfCommentDataEndGroup::new, true),
        emfMultiFormats(0x40000004L, EmfCommentDataMultiformats::new, true),
        emfWMF(-2147483647L, EmfCommentDataWMF::new, true),
        emfUnicodeString(64L, EmfCommentDataUnicode::new, true),
        emfUnicodeEnd(128L, EmfCommentDataUnicode::new, true);

        public final long id;
        public final Supplier<? extends EmfCommentData> constructor;
        public final boolean isEmfPublic;

        private HemfCommentRecordType(long id2, Supplier<? extends EmfCommentData> constructor, boolean isEmfPublic) {
            this.id = id2;
            this.constructor = constructor;
            this.isEmfPublic = isEmfPublic;
        }

        public static HemfCommentRecordType getById(long id2, boolean isEmfPublic) {
            for (HemfCommentRecordType wrt : HemfCommentRecordType.values()) {
                if (wrt.id != id2 || wrt.isEmfPublic != isEmfPublic) continue;
                return wrt;
            }
            return emfGeneric;
        }
    }
}

