/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.ComponentManager;
import org.apache.felix.scr.impl.manager.ReferenceManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.dto.DTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;

public class ServiceComponentRuntimeImpl
implements ServiceComponentRuntime,
ServiceListener,
BundleListener {
    private static final String[] EMPTY = new String[0];
    private final BundleContext context;
    private final ComponentRegistry componentRegistry;
    private volatile SoftReference<ConcurrentHashMap<Long, ServiceReferenceDTO[]>> dtoCache = new SoftReference(new ConcurrentHashMap());

    public ServiceComponentRuntimeImpl(BundleContext context, ComponentRegistry componentRegistry) {
        this.context = context;
        this.componentRegistry = componentRegistry;
        this.context.addBundleListener(this);
        this.context.addServiceListener(this);
    }

    @Override
    public Collection<ComponentDescriptionDTO> getComponentDescriptionDTOs(Bundle ... bundles) {
        List<ComponentHolder<?>> holders = bundles == null || bundles.length == 0 ? this.componentRegistry.getComponentHolders() : this.componentRegistry.getComponentHolders(bundles);
        ArrayList<ComponentDescriptionDTO> result = new ArrayList<ComponentDescriptionDTO>(holders.size());
        for (ComponentHolder<?> holder : holders) {
            ComponentDescriptionDTO dto = this.holderToDescription(holder);
            if (dto == null) continue;
            result.add(dto);
        }
        return result;
    }

    @Override
    public ComponentDescriptionDTO getComponentDescriptionDTO(Bundle bundle, String name) {
        ComponentHolder<?> holder = this.componentRegistry.getComponentHolder(bundle, name);
        if (holder != null) {
            return this.holderToDescription(holder);
        }
        return null;
    }

    @Override
    public Collection<ComponentConfigurationDTO> getComponentConfigurationDTOs(ComponentDescriptionDTO description) {
        if (description == null) {
            return Collections.emptyList();
        }
        try {
            ComponentHolder<?> holder = this.getHolderFromDescription(description);
            description = this.holderToDescription(holder);
            if (description == null) {
                return Collections.emptyList();
            }
            List<ComponentManager<?>> managers = holder.getComponents();
            ArrayList<ComponentConfigurationDTO> result = new ArrayList<ComponentConfigurationDTO>(managers.size());
            for (ComponentManager<?> manager : managers) {
                result.add(this.managerToConfiguration(manager, description));
            }
            return result;
        }
        catch (IllegalStateException ise) {
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isComponentEnabled(ComponentDescriptionDTO description) {
        try {
            ComponentHolder<?> holder = this.getHolderFromDescription(description);
            return holder.isEnabled();
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    @Override
    public Promise<Void> enableComponent(ComponentDescriptionDTO description) {
        try {
            ComponentHolder<?> holder = this.getHolderFromDescription(description);
            boolean doUpdate = !holder.isEnabled();
            Promise<Void> result = holder.enableComponents(true);
            if (doUpdate) {
                this.componentRegistry.updateChangeCount();
            }
            return result;
        }
        catch (IllegalStateException ise) {
            return Promises.failed(ise);
        }
    }

    @Override
    public Promise<Void> disableComponent(ComponentDescriptionDTO description) {
        try {
            ComponentHolder<?> holder = this.getHolderFromDescription(description);
            boolean doUpdate = holder.isEnabled();
            Promise<Void> result = holder.disableComponents(true);
            if (doUpdate) {
                this.componentRegistry.updateChangeCount();
            }
            return result;
        }
        catch (IllegalStateException ise) {
            return Promises.failed(ise);
        }
    }

    private ComponentConfigurationDTO managerToConfiguration(ComponentManager<?> manager, ComponentDescriptionDTO description) {
        ComponentConfigurationDTO dto = new ComponentConfigurationDTO();
        dto.satisfiedReferences = this.satisfiedRefManagersToDTO(manager.getReferenceManagers());
        dto.unsatisfiedReferences = this.unsatisfiedRefManagersToDTO(manager.getReferenceManagers());
        dto.description = description;
        dto.id = manager.getId();
        dto.properties = new HashMap<String, Object>(manager.getProperties());
        dto.state = manager.getSpecState();
        if (dto.state == 8 || dto.state == 4) {
            dto.service = this.serviceReferenceToDTO(manager.getRegisteredServiceReference());
        }
        if (manager.getFailureReason() != null) {
            dto.state = 16;
            dto.failure = manager.getFailureReason();
        }
        return dto;
    }

    private SatisfiedReferenceDTO[] satisfiedRefManagersToDTO(List<? extends ReferenceManager<?, ?>> referenceManagers) {
        ArrayList<SatisfiedReferenceDTO> dtos = new ArrayList<SatisfiedReferenceDTO>();
        for (ReferenceManager<?, ?> ref : referenceManagers) {
            if (!ref.isSatisfied()) continue;
            SatisfiedReferenceDTO dto = new SatisfiedReferenceDTO();
            dto.name = ref.getName();
            dto.target = ref.getTarget();
            List<ServiceReference<?>> serviceRefs = ref.getServiceReferences();
            ServiceReferenceDTO[] srDTOs = new ServiceReferenceDTO[serviceRefs.size()];
            int j = 0;
            for (ServiceReference<?> serviceRef : serviceRefs) {
                ServiceReferenceDTO srefDTO = this.serviceReferenceToDTO(serviceRef);
                if (srefDTO == null) continue;
                srDTOs[j++] = srefDTO;
            }
            dto.boundServices = srDTOs;
            dtos.add(dto);
        }
        return dtos.toArray(new SatisfiedReferenceDTO[dtos.size()]);
    }

    private UnsatisfiedReferenceDTO[] unsatisfiedRefManagersToDTO(List<? extends ReferenceManager<?, ?>> referenceManagers) {
        ArrayList<UnsatisfiedReferenceDTO> dtos = new ArrayList<UnsatisfiedReferenceDTO>();
        for (ReferenceManager<?, ?> ref : referenceManagers) {
            if (ref.isSatisfied()) continue;
            UnsatisfiedReferenceDTO dto = new UnsatisfiedReferenceDTO();
            dto.name = ref.getName();
            dto.target = ref.getTarget();
            List<ServiceReference<?>> serviceRefs = ref.getServiceReferences();
            ServiceReferenceDTO[] srDTOs = new ServiceReferenceDTO[serviceRefs.size()];
            int j = 0;
            for (ServiceReference<?> serviceRef : serviceRefs) {
                ServiceReferenceDTO srefDTO = this.serviceReferenceToDTO(serviceRef);
                if (srefDTO == null) continue;
                srDTOs[j++] = srefDTO;
            }
            dto.targetServices = srDTOs;
            dtos.add(dto);
        }
        return dtos.toArray(new UnsatisfiedReferenceDTO[dtos.size()]);
    }

    private ServiceReferenceDTO serviceReferenceToDTO(ServiceReference<?> serviceRef) {
        ServiceReferenceDTO[] dtos;
        if (serviceRef == null) {
            return null;
        }
        Bundle bundle = serviceRef.getBundle();
        if (bundle == null) {
            return null;
        }
        long bundleId = bundle.getBundleId();
        ConcurrentHashMap<Long, Object> cache = this.dtoCache.get();
        if (cache == null) {
            cache = new ConcurrentHashMap();
            this.dtoCache = new SoftReference<ConcurrentHashMap<Long, ServiceReferenceDTO[]>>(cache);
        }
        if ((dtos = cache.get(bundleId)) == null) {
            dtos = bundle.adapt(ServiceReferenceDTO[].class);
            if (dtos == null) {
                dtos = new ServiceReferenceDTO[]{};
            }
            cache.put(bundleId, dtos);
        }
        long id2 = (Long)serviceRef.getProperty("service.id");
        for (ServiceReferenceDTO dto : dtos) {
            if (dto.id != id2) continue;
            ServiceReferenceDTO result = new ServiceReferenceDTO();
            result.bundle = dto.bundle;
            result.id = dto.id;
            result.properties = new HashMap<String, Object>(dto.properties);
            if (dto.usingBundles != null) {
                result.usingBundles = new long[dto.usingBundles.length];
                if (dto.usingBundles.length > 0) {
                    System.arraycopy(dto.usingBundles, 0, result.usingBundles, 0, result.usingBundles.length);
                }
            }
            return result;
        }
        return null;
    }

    private ComponentHolder<?> getHolderFromDescription(ComponentDescriptionDTO description) {
        if (description.bundle == null) {
            throw new IllegalArgumentException("No bundle supplied in ComponentDescriptionDTO named " + description.name);
        }
        long bundleId = description.bundle.id;
        Bundle b = this.context.getBundle(bundleId);
        String name = description.name;
        return this.componentRegistry.getComponentHolder(b, name);
    }

    private ComponentDescriptionDTO holderToDescription(ComponentHolder<?> holder) {
        ComponentDescriptionDTO dto = new ComponentDescriptionDTO();
        ComponentMetadata m = holder.getComponentMetadata();
        dto.activate = m.getActivate();
        dto.bundle = this.bundleToDTO(holder.getActivator().getBundleContext());
        if (dto.bundle == null) {
            return null;
        }
        dto.configurationPid = m.getConfigurationPid().toArray(new String[m.getConfigurationPid().size()]);
        dto.configurationPolicy = m.getConfigurationPolicy();
        dto.deactivate = m.getDeactivate();
        dto.defaultEnabled = m.isEnabled();
        dto.factory = m.getFactoryIdentifier();
        dto.immediate = m.isImmediate();
        dto.implementationClass = m.getImplementationClassName();
        dto.modified = m.getModified();
        dto.name = m.getName();
        dto.properties = this.deepCopy(m.getProperties());
        dto.references = this.refsToDTO(m.getDependencies());
        dto.scope = m.getServiceMetadata() == null ? null : m.getServiceMetadata().getScope().name();
        dto.serviceInterfaces = m.getServiceMetadata() == null ? EMPTY : m.getServiceMetadata().getProvides();
        dto.factoryProperties = m.isFactory() ? m.getFactoryProperties() : null;
        dto.activationFields = m.getActivationFields() == null ? EMPTY : m.getActivationFields().toArray(new String[m.getActivationFields().size()]);
        dto.init = m.getNumberOfConstructorParameters();
        return dto;
    }

    private Map<String, Object> deepCopy(Map<String, Object> source) {
        HashMap<String, Object> result = new HashMap<String, Object>(source.size());
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            result.put(entry.getKey(), this.convert(entry.getValue()));
        }
        return result;
    }

    Object convert(Object source) {
        if (source.getClass().isArray()) {
            Class<?> type = source.getClass().getComponentType();
            if (this.checkType(type)) {
                return source;
            }
            return String.valueOf(source);
        }
        if (this.checkType(source.getClass())) {
            return source;
        }
        return String.valueOf(source);
    }

    boolean checkType(Class<?> type) {
        if (type == String.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        return DTO.class.isAssignableFrom(type);
    }

    private ReferenceDTO[] refsToDTO(List<ReferenceMetadata> dependencies) {
        ReferenceDTO[] dtos = new ReferenceDTO[dependencies.size()];
        int i = 0;
        for (ReferenceMetadata r : dependencies) {
            ReferenceDTO dto = new ReferenceDTO();
            dto.bind = r.getBind();
            dto.cardinality = r.getCardinality();
            dto.field = r.getField();
            dto.fieldOption = r.getFieldOption();
            dto.interfaceName = r.getInterface();
            dto.name = r.getName();
            dto.policy = r.getPolicy();
            dto.policyOption = r.getPolicyOption();
            dto.scope = r.getScope().name();
            dto.target = r.getTarget();
            dto.unbind = r.getUnbind();
            dto.updated = r.getUpdated();
            dto.parameter = r.getParameterIndex();
            dto.collectionType = r.getFieldCollectionType();
            dtos[i++] = dto;
        }
        return dtos;
    }

    private BundleDTO bundleToDTO(BundleContext bundleContext) {
        if (bundleContext == null) {
            return null;
        }
        try {
            Bundle bundle = bundleContext.getBundle();
            if (bundle == null) {
                return null;
            }
            BundleDTO b = new BundleDTO();
            b.id = bundle.getBundleId();
            b.lastModified = bundle.getLastModified();
            b.state = bundle.getState();
            b.symbolicName = bundle.getSymbolicName();
            b.version = bundle.getVersion().toString();
            return b;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        ConcurrentHashMap<Long, ServiceReferenceDTO[]> cache = this.dtoCache.get();
        if (cache != null) {
            cache.remove(event.getBundle().getBundleId());
        }
    }

    @Override
    public void serviceChanged(ServiceEvent event) {
        ConcurrentHashMap<Long, ServiceReferenceDTO[]> cache;
        if (event.getServiceReference() != null && (cache = this.dtoCache.get()) != null) {
            cache.remove(event.getServiceReference().getProperty("service.bundleid"));
        }
    }
}

